module test8
signature
  constructors
    Nil   : List(a)
    Cons  : a * List(a) -> List(a)

    Zero  : Nat
    Succ  : Nat -> Nat
    Plus  : Nat * Nat -> Nat

rules

  A : Plus(Zero, x) -> x
  B : Plus(Succ(x), y) -> Succ(Plus(x, y))

strategies

  try(s) = 
    s <+ id
 
  topdown(s) = 
    s; all(topdown(s))

  bottomup(s) = 
    all(bottomup(s)); s
 
  repeat(s) = 
    try(s; repeat(s))
  
  innermost(s)  = 
    bottomup(rec x(try(s; bottomup(x))))

//  innermost(s)  = 
//    bottomup(try(s; innermost(s)))

  eval = 
    innermost(A + B)

  main =  
    !Plus(Succ(Plus(Succ(Zero), Succ(Zero))), Succ(Zero));
    eval
