\literate[unification-test]

	\begin{abstract}

	\end{abstract}

% Copyright (C) 1998-2001 Eelco Visser <visser@acm.org>
% 
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
% 02111-1307, USA.

\begin{code}
module unification-test
imports sunit unification
strategies

  main =
    test-suite(!"unification-test",
	test0;
	test1
    )

signature
  constructors
    Typed  : Exp * Type -> Exp
    Var    : String -> Exp
    Forall : String * Type -> Type
    TVar   : String -> Type

strategies

  test0 = 
    apply-test(!"test0"
	,equal
	,![(Typed(Var("a"),Forall("b",TVar("b")))
           ,Typed(Var("a"),Forall("b",TVar("b"))))]
	,![]
	)

  test1 = 
    apply-test(!"test1"
	,equal( \ Typed(x,y) -> x \ )
	,![(Typed(Var("a"),Forall("b",TVar("b")))
	   ,Typed(Var("a"),Forall("c",TVar("c"))))]
	,![]
	)
\end{code}
