import straw

class MessageManager(straw.SignalEmitter):
    def __init__(self):
        straw.SignalEmitter.__init__(self)
        self.initialize_slots(straw.StatusDisplaySignal)
        self.__messages = []

    def post_message(self, message):
        self.__messages.append(message)
        self.emit_signal(straw.StatusDisplaySignal(self))

    def read_message(self):
        return self.__messages.pop(0)

    def number_of_messages(self):
        return len(self.__messages)

mm_instance = None

def get_instance():
    global mm_instance
    if mm_instance is None:
        mm_instance = MessageManager()
    return mm_instance

