cvs_id = "$Id: error.py,v 1.3 2004/04/25 13:57:29 jpakaste Exp $"

import sys
import traceback
import pprint
from StringIO import StringIO

stream = sys.stderr

def log(*args):
    caller = traceback.extract_stack()[-2]
    _log(caller, *args)

def _log(caller = None, *args):
    if caller is None:
        caller = traceback.extract_stack()[-2]
    try:
        cf = caller[0][caller[0].rindex("/")+1:]
    except:
        cf = caller[0]
    stream.write("%s:%d:%s: " % (cf, caller[1], caller[2]))
    for a in args:
        if type(a) is not type(''):
            a = repr(a)
        stream.write(a)
    stream.write("\n")

def logtb(*args):
    _log(traceback.extract_stack()[-2], *args)
    l = traceback.format_list(traceback.extract_stack()[:-1])
    for e in l:
        stream.write(e)

def logparam(locals, *vars):
    logargs = []
    for v in vars:
        logargs.append(v + ": " + str(locals[v]))
    _log(traceback.extract_stack()[-2], ", ".join(logargs))
    
def logpparam(locals, *vars):
    logargs = []
    for v in vars:
        sio = StringIO()
        pprint.pprint(locals[v], sio)
        logargs.append(v + ": " + sio.getvalue())
        sio.close()
    _log(traceback.extract_stack()[-2], "".join(logargs))
    
