""" OPMLImport.py
"""

__copyright__ = "Copyright (c) 2002-2005 Free Software Foundation, Inc."
__license__ = """
Straw is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

Straw is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA. """


import OPML
import Feed
import FeedList

class BlogListEntry(object):
    __slots__ = ('text', 'url')

def _find_entries(outline):
    entries = []
    for c in outline.children:
        entries += _find_entries(c)
    type = outline.get('type', '')
    text = outline.get('text', '')
    e = None
    if type == 'link':
        url = outline.get('url', '')
        if url != '':
            e = BlogListEntry()
            e.text = text
            e.url = url
    else:
        xmlurl = outline.get('xmlUrl', '')
        e = BlogListEntry()
        e.text = text
        if text == '':
            title = outline.get('title', '')
            if title == '':
                e = None
            e.text = title
        if e != None:
            if xmlurl != '':
                # there's something in xmlurl. There's a good chance that's
                # our feed's URL
                e.url = xmlurl
            else:
                htmlurl = outline.get('htmlUrl', '')
                if htmlurl != '':
                    # there's something in htmlurl, and xmlurl is empty. This
                    # might be our feed's URL.
                    e.url = htmlurl
                else:
                    # nothing else to try.
                    e = None
    if e is not None:
        entries[0:0] = [e]
    return entries

def find_entries(outlines):
    entries = []
    for o in outlines:
        entries += _find_entries(o)
    return entries

def read(stream):
    try:
        o = OPML.parse(stream)
    except ValueError:
        return None
    entries = find_entries(o.outlines)
    ret = list()
    edict = dict()
    # avoid duplicates.
    for e in entries:
        ek = (e.text, e.url)
        edict[ek] = edict.get(ek, 0) + 1
        if edict[ek] < 2:
            ret.append(e)
    return ret

def import_opml(filename,category=None):
    feedlist = FeedList.get_instance()
    fstream = open (filename)
    opml = read(fstream)
    if not opml:
        return
    feeds = [feed.access_info[0] for feed in feedlist]
    newitems = [Feed.Feed.create_new_feed(b.text, b.url) for b in opml if b.url not in feeds]
    feedlist.extend(category, newitems)
    return
