/*
 * $Id: st-category-bag.h,v 1.19 2004/03/27 21:34:29 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_CATEGORY_BAG_H
#define _ST_CATEGORY_BAG_H

#include <gtk/gtk.h>
#include "st-category-api.h"
#include "st-handler-api.h"

#define ST_TYPE_CATEGORY_BAG		(st_category_bag_get_type())
#define ST_CATEGORY_BAG(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_CATEGORY_BAG, STCategoryBag))
#define ST_CATEGORY_BAG_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_CATEGORY_BAG, STCategoryBagClass))
#define ST_IS_CATEGORY_BAG(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_CATEGORY_BAG))
#define ST_IS_CATEGORY_BAG_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_CATEGORY_BAG))
#define ST_CATEGORY_BAG_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_CATEGORY_BAG, STCategoryBagClass))

#define ST_CATEGORY_BAG_SELECTED	(1 << 0)
#define ST_CATEGORY_BAG_EXPANDED	(1 << 1)

#define ST_CATEGORY_BAG_IS_SELECTED(bag) \
  ((st_category_bag_get_flags((bag)) & ST_CATEGORY_BAG_SELECTED) != 0)
#define ST_CATEGORY_BAG_IS_EXPANDED(bag) \
  ((st_category_bag_get_flags((bag)) & ST_CATEGORY_BAG_EXPANDED) != 0)

#define ST_CATEGORY_BAG_MAIN		"__main"
#define ST_CATEGORY_BAG_SEARCH		"__search"

#define ST_CATEGORY(bag) \
  ((bag)->category)
#define ST_CATEGORY_BAG_NAME_IS_STOCK(name) \
  ((name)[0] == '_' && (name)[1] == '_')
#define ST_CATEGORY_BAG_IS_STOCK(bag) \
  (ST_CATEGORY_BAG_NAME_IS_STOCK(ST_CATEGORY((bag))->name))
#define ST_CATEGORY_BAG_IS(bag, _name) \
  (! strcmp(ST_CATEGORY((bag))->name, (_name)))

typedef struct _STCategoryBagPrivate	STCategoryBagPrivate;

typedef struct
{
  GObject		object;

  STCategory		*category;
  STHandler		*handler;

  GtkTreeIter		iter;

  STCategoryBagPrivate	*priv;
} STCategoryBag;

typedef struct
{
  GObjectClass		parent_class;
} STCategoryBagClass;

GType		st_category_bag_get_type            (void);

STCategoryBag	*st_category_bag_new                (STHandler	*handler);
STCategoryBag	*st_category_bag_new_from_category  (STHandler	*handler,
						     STCategory	*category);

void		st_category_bag_set_flags	(STCategoryBag	*bag,
						 unsigned int	flags);
void		st_category_bag_unset_flags	(STCategoryBag	*bag,
						 unsigned int	flags);
unsigned int	st_category_bag_get_flags	(STCategoryBag	*bag);

gboolean	st_category_bag_apply_url_cb	(STCategoryBag	*bag);

#endif /* _ST_CATEGORY_BAG_H */
