/*
 * $Id: st-handler-api.h,v 1.40 2004/03/25 01:39:08 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_HANDLER_API_H
#define _ST_HANDLER_API_H

#include <glib.h>
#include <glib-object.h>
#include "st-category-api.h"
#include "st-handler-field-api.h"
#include "st-stream-api.h"

#define ST_TYPE_HANDLER			(st_handler_get_type())
#define ST_HANDLER(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_HANDLER, STHandler))
#define ST_HANDLER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_HANDLER, STHandlerClass))
#define ST_IS_HANDLER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_HANDLER))
#define ST_IS_HANDLER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_HANDLER))
#define ST_HANDLER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_HANDLER, STHandlerClass))

#define ST_HANDLER_NO_CATEGORIES	(1 << 0)
#define ST_HANDLER_CONFIRM_DELETION	(1 << 1)

typedef struct _STHandlerPrivate STHandlerPrivate;

typedef struct
{
  GObject		object;

  STHandlerPrivate	*priv;
} STHandler;
  
typedef struct
{
  GObjectClass		parent_class;
} STHandlerClass;
  
typedef enum				/* field type			*/
{					/* ---------------------------- */
  ST_HANDLER_STOCK_FIELD_NAME,		/* G_TYPE_STRING		*/
  ST_HANDLER_STOCK_FIELD_GENRE		/* G_TYPE_STRING		*/
} STHandlerStockField;

typedef enum
{
  ST_HANDLER_EVENT_REFRESH,
  
  ST_HANDLER_EVENT_STREAM_NEW,
  ST_HANDLER_EVENT_STREAM_FIELD_GET,
  ST_HANDLER_EVENT_STREAM_FIELD_SET,
  ST_HANDLER_EVENT_STREAM_FREE,

  ST_HANDLER_EVENT_STREAM_TUNE_IN,
  ST_HANDLER_EVENT_STREAM_RECORD,
  ST_HANDLER_EVENT_STREAM_BROWSE,

  ST_HANDLER_EVENT_CATEGORY_NEW,
  ST_HANDLER_EVENT_CATEGORY_FREE,

  /* FIXME: those are not handler specific, should be plugin-wide callbacks */
  ST_HANDLER_EVENT_THREAD_BEGIN,
  ST_HANDLER_EVENT_THREAD_END,

  ST_HANDLER_EVENT_STREAM_TUNE_IN_MULTIPLE,
  ST_HANDLER_EVENT_REFRESH_MULTIPLE,

  ST_HANDLER_EVENT_STREAM_MODIFY,
  ST_HANDLER_EVENT_STREAM_DELETE,

  ST_HANDLER_EVENT_STREAM_STOCK_FIELD_GET,
  ST_HANDLER_EVENT_STREAM_RESOLVE,

  ST_HANDLER_N_EVENTS
} STHandlerEvent;

/*
 * CATEGORY is the category to refresh.
 * CATEGORIES is a location to store a GNode of Category objects
 * STREAMS is a location to store a GList of Stream objects
 *
 * Must return false in case of abort (if the abort was caused by an error
 * condition, ERR must be set).
 *
 */
typedef gboolean   (STHandlerRefreshCallback)  (STCategory	*category,
						GNode		**categories,
						GList		**streams,
						gpointer	data,
						GError		**err);

typedef gboolean   (STHandlerRefreshMultipleCallback) (GNode      **categories,
						       GHashTable **streams,
						       gpointer   data,
						       GError     **err);

typedef STCategory*(STCategoryNewCallback)     (gpointer	data);
typedef void       (STCategoryFreeCallback)    (STCategory	*category,
						gpointer	data);

typedef STStream*  (STStreamNewCallback)       (gpointer	data);
typedef void	   (STStreamFieldGetCallback)  (STStream	*stream,
						STHandlerField	*field,
						GValue		*value,
						gpointer	data);
typedef void	   (STStreamFieldSetCallback)  (STStream	*stream,
						STHandlerField	*field,
						const GValue	*value,
						gpointer	data);
typedef gboolean   (STStreamModifyCallback)    (STStream	*stream,
						GSList		*fields,
						GSList		*values,
						gpointer	data,
						GError		**err);
typedef gboolean   (STStreamDeleteCallback)    (STStream	*stream,
						gpointer	data,
						GError		**err);
typedef void	   (STStreamFreeCallback)      (STStream	*stream,
						gpointer	data);

/*
 * STREAM is the stream to be acted upon.
 *
 * Must return false in case of abort (if the abort was caused by an error
 * condition, ERR must be set).
 *
 */
typedef gboolean   (STStreamResolveCallback)   (STStream	*stream,
						gpointer	data,
						GError		**err);
typedef gboolean   (STStreamTuneInCallback)    (STStream	*stream,
						gpointer	data,
						GError		**err);
typedef gboolean   (STStreamRecordCallback)    (STStream	*stream,
						gpointer	data,
						GError		**err);
typedef gboolean   (STStreamBrowseCallback)    (STStream	*stream,
						gpointer	data,
						GError		**err);

typedef gpointer   (STThreadBeginCallback)     (gpointer	data);
typedef void       (STThreadEndCallback)       (gpointer	thread_data,
						gpointer	data);

typedef gboolean   (STStreamTuneInMultipleCallback) (GSList	*streams,
						     gpointer	data,
						     GError	**err);

typedef void       (STStreamStockFieldGetCallback)  (STStream	*stream,
						     STHandlerStockField stock_field,
						     GValue	*value,
						     gpointer	data);

GType      st_handler_get_type                  (void);
STHandler  *st_handler_new			(const char	*name);

void       st_handler_set_label			(STHandler	*handler,
						 const char	*label);
void       st_handler_set_copyright		(STHandler	*handler,
						 const char	*copyright);
void       st_handler_set_description		(STHandler	*handler,
						 const char	*description);
void       st_handler_set_home			(STHandler	*handler,
						 const char	*home);
void	   st_handler_set_icon_from_inline	(STHandler	*handler,
						 int		size,
						 const guint8	*data);
gboolean   st_handler_set_icon_from_file	(STHandler	*handler,
						 const char	*filename,
						 GError		**err);
void       st_handler_set_stock_categories	(STHandler	*handler,
						 GNode		*categories);
void       st_handler_set_flags			(STHandler	*handler,
						 unsigned int	flags);
void       st_handler_add_field			(STHandler	*handler,
						 STHandlerField	*field);
void       st_handler_bind			(STHandler	*handler,
						 STHandlerEvent	event,
						 gpointer	cb,
						 gpointer	data);

/* deprecated API */

void       st_handler_set_info			(STHandler	*handler,
						 const char	*label,
						 const char	*copyright);
void       st_handler_set_icon			(STHandler	*handler,
						 int		size,
						 const guint8	*data);

#define ST_HANDLER_EVENT_RELOAD		ST_HANDLER_EVENT_REFRESH
#define N_ST_HANDLER_EVENTS		ST_HANDLER_N_EVENTS

#define STHandlerReloadCallback		STHandlerRefreshCallback

#endif /* _ST_HANDLER_API_H */
