#include "fileinputstream.h"
using namespace jstreams;

/* functions missing from the stream:
   - is the next value a certain string?
   - skip x character, throw exception on failure
   - advance one character
   - ensure the pointer points to the next 4 characters
*/

bool
isPdfWhitespace(char c) {
    return c==0x00||c==0x09||c==0x0A||c==0x0C||c==0x0D||c==0x20;
}
bool
isPdfDelimiter(char c) {
    return c=='('||c==')'||c=='<'||c=='>'||c=='['||c==']'||c=='{'||c=='}'
        ||c=='/'||c=='%';
}

bool
parse(const char* c, int64_t n) {
    const char* e = c+n-1;
    while (e > c && isPdfWhitespace(*e)) --e;
    //printf("%p %.5s\n", e, e-4);
    if (e-c < 4 || strncmp(e-4, "%%EOF", 5)) return false;
    e -= 5;
    while (e > c && isPdfWhitespace(*e)) --e;
    while (e > c && *e >= '0' && *e <= '9') --e;
    int i = atoi(e+1);
    e -= i;
    printf("%i %p '%.10s'\n", i, e, c+i);
    return true;
}

int
main(int argc, char** argv) {
    for (int i=1; i<argc; ++i) {
        FileInputStream file(argv[i]);
        const char*c;
        int64_t s = file.getSize();
        int64_t n = file.read(c, s, 0);
        if (n > 0 && n == file.getSize()) {
            printf("ok? %i\n", parse(c, n));
        }
    }
    return 0;
}
