#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xE5, 0x59, 0x58, 0x79, 0x7D, 0x2B, 0x55, 0xF4, 0xEB, 0x1A, 
	0x3F, 0xCE, 0x8E, 0x83, 0x81, 0xCD, 0xCD, 0x03, 0x91, 0x2D, 
	0xE4, 0x98, 0xDC, 0x3D, 0xB3, 0x16, 0x79, 0x6E, 0x1D, 0x5F, 
	0x6C, 0xCC, 0x86, 0x56, 0x7B, 0xAA, 0x20, 0x37, 0xBA, 0x4E, 
	0x33, 0x2F, 0x24, 0x9E, 0x67, 0x0B, 0x9C, 0x9D, 0x5E, 0x8B, 
	0x9F, 0x89, 0x88, 0xEA, 0x1A, 0x9A, 0x91, 0x80, 0x58, 0x8E, 
	0x64, 0xF4, 0xB6, 0x55, 0xD6, 0xEB, 0xA2, 0xCD, 0xAC, 0xC4, 
	0xAE, 0xD9, 0xFB, 0xEE, 0x72, 0x60, 0xD6, 0x3A, 0x2D, 0x43, 
	0xA0, 0xB0, 0x94, 0x24, 0xD3, 0xEF, 0xC1, 0xB7, 0xFE, 0x61, 
	0x07, 0x69, 0xF8, 0xBD, 0xC4, 0xD1, 0x99, 0xB4, 0x55, 0xD2, 
	0x89, 0x40, 0xD3, 0xC6, 0x27, 0x74, 0xBE, 0x6D, 0xA5, 0xCD, 
	0x13, 0x1F, 0x1B, 0x22, 0x28, 0x32, 0xDD, 0x5B, 0xE5, 0x7A, 
	0xD9, 0x87, 0x1C, 0x7C, 0x50, 0x2F, 0x55, 0x7B, 0x61, 0xB9, 
	0xDF, 0x92, 0xC9, 0x3E, 0x48, 0xFE, 0x91, 0xE7, 0x1F, 0x8D, 
	0x34, 0x45, 0x81, 0x6C, 0xFB, 0xE7, 0x73, 0x20, 0xD7, 0x58, 
	0xCD, 0xC8, 0xD3, 0xCD, 0x2D, 0x72, 0x56, 0x1B, 0xEC, 0xC5, 
	0x00, 0xF9, 0x5F, 0xF8, 0xBA, 0x69, 0x22, 0xDD, 0xF5, 0x98, 
	0xDB, 0xFB, 0xD1, 0xA8, 0x93, 0x30, 0xCC, 0x42, 0x70, 0x04, 
	0x94, 0xE3, 0x86, 0x15, 0xE3, 0x78, 0x0F, 0x82, 0xF9, 0x5C, 
	0xBF, 0x94, 0xC6, 0xF4, 0x75, 0x69, 0x64, 0x3E, 0xF3, 0x65, 
	0x07, 0x3C, 0x90, 0xBA, 0x08, 0xE4, 0xB7, 0xCF, 0xA8, 0x44, 
	0xCF, 0x47, 0x70, 0xE6, 0xE9, 0xF6, 0xD2, 0x3F, 0xD1, 0xA7, 
	0x30, 0x7C, 0x83, 0x8B, 0x09, 0x92, 0x28, 0xC4, 0xE6, 0x7A, 
	0xD5, 0xFA, 0x7F, 0x91, 0xD9, 0x33, 0x61, 0x29, 0x4D, 0xA1, 
	0xD5, 0x00, 0x6D, 0x77, 0x76, 0xB3, 0xAB, 0x01, 0x61, 0x14, 
	0x80, 0xEC, 0x62, 0x4E, 0x54, 0xCB
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
