/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kde.sch@ttgen.net                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "ecmafunc.h"
#include <kjs/value.h>
#include <kjs/object.h>

class ECMAFuncObjectImp : public KJS::ObjectImp
{
public:
    ECMAFuncObjectImp(ECMAFunc* owner) : ObjectImp()
    {
        this->owner = owner;
    }
    
    virtual bool implementsCall() const 
    { 
        return true; 
    }
    
    virtual KJS::Value call(KJS::ExecState *exec, 
        KJS::Object &thisObj, const KJS::List &args)
    {
        KJS::Value ret = KJS::Undefined();
        emit owner->call(exec, thisObj, args, ret);
        return ret;
    }
    
private:
    ECMAFunc* owner;
};

ECMAFunc::ECMAFunc(QObject* parent) : QObject(parent)
{
    this->objectImp = new ECMAFuncObjectImp(this);
}

ECMAFunc::~ECMAFunc()
{
    delete this->objectImp;
}

KJS::ObjectImp* ECMAFunc::getObjectImp() const
{
    return objectImp;
}

/*KJS::Value MyFuncObj::call(KJS::ExecState *exec, KJS::Object &, const KJS::List &args)
{
        KMessageBox::information(NULL, "called MyFuncObj::call()", "clock");
        if(args[0].toString(exec) == "success")
                return KJS::Number(1);
        else
                return KJS::Undefined();
}*/



#include "ecmafunc.moc"
