/*
 * Copyright (C) 2004 Fred Schaettgen <Sch@ttgen.net>
 */

#ifndef _FASHIONCLOCKVIEW_H_
#define _FASHIONCLOCKVIEW_H_

#include <qwidget.h>
#include <kparts/part.h>
#include <fashionclockiface.h>
#include "../styleclockwidget/clockappinterface.h"

class QPainter;
class KURL;
class ClockPaintView;
class Prefs;

/**
 * This is the main view class for FashionClock.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This fashionclock uses an HTML component as an example.
 *
 * @short Main view
 * @author Fred Schaettgen <Sch@ttgen.net>
 * @version 0.1
 */
class FashionClockView : public QWidget, public ClockAppInterface, public FashionClockIface
{
    Q_OBJECT
public:
	/**
	 * Default constructor
	 */
    FashionClockView(QWidget *parent, Prefs* prefs);

	/**
	 * Destructor
	 */
    virtual ~FashionClockView();

    /**
     * Random 'get' function
     */
    QString currentURL();

    /**
     * Random 'set' function accessed by DCOP
     */
    virtual void openURL(QString url);

    /**
     * Random 'set' function
     */
    virtual void openURL(const KURL& url);

    /**
     * Print this view to any medium -- paper or not
     */
    void print(QPainter *, int height, int width);

    QDateTime getAlarmTime();

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const QString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const QString& text);

private slots:

private:
    ClockPaintView *m_clock;
};

#endif // _FASHIONCLOCKVIEW_H_
