/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [sysbase1.h]                Standard Definitions ( Part 1 )                */
/*                                                                            */
/* Copyright (c) 1993 by D\olle, Manns                                        */
/* -------------------------------------------------------------------------- */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef sysbase1_INCL
#define sysbase1_INCL


#include "sysbase0.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ----------------- Byte/String & VarArg Handling -------------------------- */

#define CORE            fprintf(STDOUT,"Objects = %ld\n", ObjCount())
#define BUG_CORE        bug1(ObjCount() == 0,"%ld objects",ObjCount())
#define BUG_CORE_EX(c)  bug1(ObjCount()+(c) == 0,"%ld objects",ObjCount()+(c))
#define New(TYPE)       (TYPE)NewMem(SizeOf(TYPE))

StdCPtr BytCopy(StdCPtr bytes, long len)
/* copies 'len' bytes of byte array 'bytes';
   allocs memory
*/
;

c_bstring BytToBStrCopy(StdCPtr bytes, long len)
/* constructs a binary string
   from 'len' bytes of byte array 'bytes';
   allocs memory
*/
;

c_string BytToHStrCopy(StdCPtr bytes, long len)
/* creates a hex string from 'len' bytes of byte array 'bytes';
   allocs memory
*/
;

c_string BStrToHStrCopy(c_bstring bstr)
/* creates a hex string from binary string 'bstr';
   allocs memory
*/
;

c_bool IsSpaceStr(c_string s)
/* whether string 's' is empty or
   only contains space characters
*/
;

size_t WCStrLen(wc_string ws)
/* number of wide characters in string 'ws'
   ( without the termination character )
*/
;

wc_string SubWCStrCopy(wc_string str, long len)
/* copies 'len' wide characters of string 'str';
   appends 0, allocs memory
*/
;

wc_string WCStrCopy(wc_string Str)
/* copies wide character string 'Str'; allocs memory */
;

c_string WCToStrCopy(wc_string wc)
/* copies wide character string 'wc' into a string;
   without conversion, allocs memory
*/
;

wc_string WCStrToLower(wc_string st)
/* converts all letters in wide character string 'st' to lower case */
;

wc_string WCStrToUpper(wc_string st)
/* converts all letters in wide character string 'st' to upper case */
;

c_string SubStrCopy(c_string str, long len)
/* copies 'len' characters of string 'str';
   appends 0, allocs memory
*/
;

c_string StrCopy(c_string Str);       /* copies string 'Str'; allocs memory */

c_string StrToLower(c_string st)
/* converts all letters in string 'st' to lower case */
;

c_string StrToUpper(c_string st)
/* converts all letters in string 'st' to upper case */
;

Any_T* MakeArgLst(va_list args, int fixed_cnt, ...)
/* MakeArgLst is a portable replacement for GetArgLst coping with the
 * idiosyncracies of different va_list implementations. Since there is
 * no portable way to pass a va_list (caller's variable arguments)
 * through '...', it has to be moved before the caller's fixed args.
 * fixed_cnt is the count of the caller's fixed arguments.
 *
 * Sample usage:
 *   variadic_func(int argcnt, TYPEA a, TYPEB b, TYPEC c, ...)
 *   {
 *     va_list va;
 *     Any_T *argl;
 *     va_start(va,c); // Must use the *last* fixed argument here
 *     argl = MakeArgLst(va, 4, argcnt, a, b, c);
 *     va_end(va);
 *     // make use of argl
 *     FreeMem(argl);
 *   }
 *
 * For an in depth discussion of variadic functions including
 * portability, see libc.info Node: Variadic Functions.
*/
;


/* ------------- Workaround for missing C library functions ----------------- */

c_string strstr_aux(c_string s1, c_string s2); /* workaround for 'strstr'   */
c_string strchr_aux(c_string s, int c);        /* workaround for 'strchr'   */
c_string strrchr_aux(c_string s, int c);       /* workaround for 'strrchr'  */
int strcspn_aux(c_string s, c_string reject); /* workaround for 'strcspn'   */

StdCPtr memcpy_aux(StdCPtr dst, StdCPtr src, int n)
/* workaround for 'memcpy' */
;

int memcmp_aux(StdCPtr dst, StdCPtr src, int n); /* workaround for 'memcmp' */

c_string getcwd_aux(c_string buffer, int bufsize)
/* workaround for 'getcwd'; evaluates $PWD */
;


/* -------------------------- System Error ---------------------------------- */

c_string GetSystemError(void);       /* system error message; allocs memory */

c_string GetSystemError_noalloc(c_string buffer, int bufsize)
/* system error message */
;


/* -------------------------- Program Execution ----------------------------- */

#define STD_CMD_NOWAIT     0
#define STD_CMD_WAIT_INIT  1
#define STD_CMD_WAIT       2

int runprg(c_string cmd, int cmdflg)
/* executes program 'cmd'
   cmdflg=STD_CMD_NOWAIT    --> asynchron, non-blocking
   cmdflg=STD_CMD_WAIT_INIT --> waits for initialisation
   cmdflg=STD_CMD_WAIT      --> synchron, blocking
*/
;


/* ----------------- DLL & dynamic Function Call Support -------------------- */

typedef StdCPtr (*PCFUN)();

StdCPtr apply_fun_portable(PCFUN f, int cnt, StdCPtr* args)
/* portable dynamic call of C-function 'f'
   with 'cnt' parameters in 'args'
   ( upto 9 parameters )
*/
;

StdCPtr apply_fun(PCFUN f, int cnt, StdCPtr* args)
/* dynamic call of C-function 'f'
   with 'cnt' parameters in 'args'
   ( restricted to intel )
*/
;


AbstractType( DL_Hdl ); /* Abstract handle type */

#define DL_LOAD_LAZY    0

#if !defined(STYX_CONFIG_OSMS) && (!defined(HAVE_CONFIG_H) || (defined(HAVE_LIBDL) && defined(HAVE_DLFCN_H)))
#define DL_LAZY         RTLD_LAZY
#define DL_NOW          RTLD_NOW
#define DL_BINDING_MASK RTLD_BINDING_MASK
#define DL_GLOBAL       RTLD_GLOBAL
#define DL_LOCAL        RTLD_LOCAL
#else
#define DL_LAZY         0
#define DL_NOW          0
#define DL_BINDING_MASK 0
#define DL_GLOBAL       0
#define DL_LOCAL        0
#endif

DL_Hdl DL_open(c_string dlname, int flag)
/* loads dll 'dlname' in mode 'flag' ( ERROR: NULL )
   LINUX: flag=RTLD_LAZY|RTLD_NOW|-1=RTLD_NOW, MS: not used
*/
;

int DL_close(DL_Hdl dlhdl)
/* detaches dll 'dlhdl' ( SUCCESS: 0, ERROR: > 0 ) */
;

StdCPtr DL_symbol(DL_Hdl dlhdl, c_string symname)
/* address of symbol 'symname' within dll 'dlhdl' ( ERROR: NULL )
   LINUX: function|data, MS: function
*/
;

c_string DL_error(void);               /* dll load error; allocs memory     */
c_string DL_error_noalloc(c_string buffer, int bufsize); /* dll load error  */

/* ---------------------- Network Support ----------------------------------- */

c_string UserName(void);               /* login name; allocs memory         */


#ifdef __cplusplus
}
#endif

#endif
