/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MERGEPARAM_H
#define _SC_MERGEPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"

/**
 * Parameter class for MergeCmd.
 */
class MergeParam : public ScParam
{
public:
  MergeParam( const char* pathOrUrl1, const svn::Revision* rev1, const char* pathOrUrl2,
    const svn::Revision* rev2, const svn::Revision* revPeg, const char* targetPath,
    bool recurse, bool ancestry, bool interactive, bool force, bool dryrun )
    : _pathOrUrl1(pathOrUrl1), _rev1(rev1), _pathOrUrl2(pathOrUrl2), _rev2(rev2),
    _revPeg(revPeg), _targetPath(targetPath), _recurse(recurse), _ancestry(ancestry),
    _interactive(interactive), _force(force), _dryrun(dryrun)
  {
  }

  ~MergeParam()
  {
    delete _rev1;
    delete _rev2;
    delete _revPeg;
  }

  bool isPeg() const
  {
    return _revPeg != 0;
  }

  const sc::String& getPathOrUrl1() const
  {
    return _pathOrUrl1;
  }

  const sc::String& getPathOrUrl2() const
  {
    return _pathOrUrl2;
  }

  const svn::Revision* getPegRevision() const
  {
    return _revPeg;
  }

  const svn::Revision* getRevision1() const
  {
    return _rev1;
  }

  const svn::Revision* getRevision2() const
  {
    return _rev2;
  }

  const sc::String& getTargetPath() const
  {
    return _targetPath;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  bool getAncestry() const
  {
    return _ancestry;
  }

  bool getInteractive() const
  {
    return _interactive;
  }

  bool getForce() const
  {
    return _force;
  }

  bool getDryRun() const
  {
    return _dryrun;
  }

  ScParamAccept(MergeParam);

private:
  // in
  sc::String           _pathOrUrl1;
  const svn::Revision* _rev1;

  sc::String           _pathOrUrl2;   ///< only valid if _revPeg is 0
  const svn::Revision* _rev2;
  const svn::Revision* _revPeg;

  sc::String           _targetPath;
  bool                 _recurse;
  bool                 _ancestry;
  bool                 _interactive;
  bool                 _force;
  bool                 _dryrun;
};

#endif // _SC_MERGEPARAM_H
