/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_REVISION_H
#define _SVN_REVISION_H

// sc
#include "svn.h"
#include "util/String.h"

// boost
#include <boost/shared_ptr.hpp>

// svn
#include "svn_opt.h"


namespace svn
{

// opt/svn_opt_revision_kind
enum RevisionKind
{
  Revision_Unspecified = svn_opt_revision_unspecified,
  Revision_Number      = svn_opt_revision_number,
  Revision_Date        = svn_opt_revision_date,
  Revision_Committed   = svn_opt_revision_committed,
  Revision_Previous    = svn_opt_revision_previous,
  Revision_Base        = svn_opt_revision_base,
  Revision_Working     = svn_opt_revision_working,
  Revision_Head        = svn_opt_revision_head
};



// opt/svn_opt_revision_t
class Revision
{
public:
  Revision( RevisionKind kind ) : _kind(kind)
  {
  }

  virtual ~Revision()
  {
  }

public:
  RevisionKind getKind() const;

  bool isLocal() const;

  virtual bool equals( const Revision* ) const;
  virtual const Revision* dup() const;

  virtual sc::String toString() const;

protected:
  RevisionKind _kind;
};


class RevisionDate : public Revision
{
public:
  RevisionDate( const Date& d ) : Revision(Revision_Date), _date(d)
  {
  }

  const Date& getDate() const
  {
    return _date;
  }

  bool equals( const Revision* ) const;
  const Revision* dup() const;

  sc::String toString() const;

private:
  Date _date;
};

class RevisionNumber : public Revision
{
public:
  RevisionNumber( const Revnumber& r ) : Revision(Revision_Number), _rev(r)
  {
  }

  const Revnumber& getNumber() const
  {
    return _rev;
  }

  bool equals( const Revision* ) const;
  const Revision* dup() const;

  sc::String toString() const;

private:
  Revnumber _rev;
};


const Revision RevUnspecified = Revision(Revision_Unspecified);
const Revision RevCommited    = Revision(Revision_Committed);
const Revision RevPrevious    = Revision(Revision_Previous);
const Revision RevBase        = Revision(Revision_Base);
const Revision RevWorking     = Revision(Revision_Working);
const Revision RevHead        = Revision(Revision_Head);


typedef boost::shared_ptr<Revision>  RevisionPtr;

} // namespace


#endif //  _SVN_REVISION_H

