/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

//sc
#include "AprException.h"
#include "apr.h"
#include "Error.h"


namespace apr
{

Exception::Exception( apr_status_t status, const sc::String& msg )
{
  _error = createError( status, strError(status) );
}

Exception::~Exception()
{
  delete _error;
}

const sc::Error* Exception::getError() const
{
  return _error;
}

} // namespace
