/* ====================================================================
 * Copyright (c) 2008,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "BookmarkViewProxyModel.h"
#include "BookmarkViewItemModel.h"
#include "Bookmark.h"


BookmarkViewProxyModel::BookmarkViewProxyModel()
{
}

BookmarkViewProxyModel::~BookmarkViewProxyModel()
{
}

bool BookmarkViewProxyModel::filterAcceptsRow( int sourceRow, const QModelIndex& sourceParent ) const
{
  QModelIndex index = sourceModel()->index( sourceRow, 0, sourceParent );
  Bookmark*   bm    = index.data( BookmarkViewItemModel::BookmarkRole ).value<Bookmark*>();

  return bm->isVisible();
}

QModelIndex BookmarkViewProxyModel::index( Bookmark* bookmark )
{
  BookmarkViewItemModel* model = dynamic_cast<BookmarkViewItemModel*>(sourceModel());

  QModelIndex index = model->index(bookmark);
  return mapFromSource(index);
}
