/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWTREE_H
#define _SC_WCVIEWTREE_H

// sc
#include "TreeView.h"
#include "WcViewViewState.h"
#include "svn/WcStatusTypes.h"
#include "util/String.h"
class WcViewStatusData;
class WcViewTreeItemModel;
class WcViewTreeProxyModel;
class DeepStatus;
class WcSelection;
class ActionStorage;
class DragInfo;

// qt
class Q3PopupMenu;


/**
 * Working copy display widget. It can be configured as a tree view or a
 * flat view. The flat view is a tree view with minimum indentation and
 * no tree decoration. Internally it is always based on a tree model.
 *\todo rename to WcViewView
 */
class WcViewTree : public TreeView
{
  typedef TreeView super;
  Q_OBJECT

public:
  WcViewTree( const sc::String& root, WcViewViewState* state, ActionStorage* as, QWidget* parent );
  ~WcViewTree();

public slots:
  /** remove old info.. */
  void updateOld( const sc::String&, const svn::WcStatuss& );
  /** ..add new info */
  void updateNew( const sc::String&, const svn::WcStatuss&, bool deep );
  /** change the current dir */
  void updateDeepStatus( const sc::String& path, const DeepStatus& status );
  /** Handle update start signal for @a path. */

  void setCurrentDir( const sc::String& newCurrent );
  /** refresh the view, honoring any option changes */
  void refresh();
  /** adjust to state type */
  void refreshType();

  // Q.. overwrites
  void contextMenuEvent( QContextMenuEvent* e );
  /** update actions after selection change */
  void selectionChanged( const QItemSelection& selected, const QItemSelection& deselected );
  
  void mouseDoubleClickEvent( QMouseEvent* e );
  /** Rename the current item to @a text. */
  void renameItem( const QString& text );
  void storeState( const QModelIndex& index );
  void expandedItem( const QModelIndex& index );
  void collapsedItem( const QModelIndex& index );

  void showEvent( QShowEvent* );
  void mousePressEvent( QMouseEvent* e );
  void mouseMoveEvent( QMouseEvent* e );
  void dragEnterEvent( QDragEnterEvent* e );
  void dragMoveEvent( QDragMoveEvent* e );
  void dragLeaveEvent( QDragLeaveEvent* e );
  void dropEvent( QDropEvent* e );
  void timerEvent( QTimerEvent* e );

signals:
  /** Signal move item, set base if @a to is a basename, else a dirname is asumed. */
  void move( const sc::String& to, bool base );
  void copy( const sc::String& to );
  /** notify current dir change */
  void currentChanged( const sc::String& );
  void selectionChanged( const WcSelection& );
  /** signal ... */
  void itemExpanded( const QModelIndex& index );
  void itemCollapsed( const QModelIndex& index );

private:
  void updateMenu( const WcSelection& sel );
  void getSelection( svn::WcStatuss& statuss );
  QMimeData* mimeData( const QModelIndexList& list );
  void restoreState( const QModelIndex& index );
  void restoreStates( const QModelIndex& index );
  void setChildsExpanded( const QModelIndex& index );
 
  WcViewStatusData*     _itemData;
  WcViewTreeItemModel*  _itemModel;
  WcViewTreeProxyModel* _proxyModel;

  WcViewViewState*      _state;

  ActionStorage*        _actions;
  Q3PopupMenu*          _menu;

  bool                  _restoringState;   ///< i.e. ignore expanded/collapsed signals.
};

#endif // _SC_WCVIEWTREE_H
