/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ScCmd.h"
#include "CmdProgressCallback.h"
#include "../Cancel.h"
#include "svn/Client.h"
#include "svn/ClientContext.h"


ScCmd::ScCmd( unsigned long cid ) : _client(0), _id(cid)
{
}

ScCmd::~ScCmd()
{
}

void ScCmd::run( svn::Client* client, CmdProgressCallback* progress )
{
  _client = client;
  _prgscb = progress;

  apr_time_t t1 = apr_time_now();

  run();

  apr_time_t t2 = apr_time_now();

  _prgscb->time( _id, ((double)(t2-t1)/1000.0) );
}

unsigned long ScCmd::getId() const
{
  return _id;
}

Cancel* ScCmd::getCancel() const
{
  // hmm...
  return dynamic_cast<Cancel*>(_client->getContext()->getCancelBaton());
}

