/* ====================================================================
 * Copyright (c) 2003-2008, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "AboutDialog.h" 
#include "Gui.h"
#include "version.out.h"
#include "Utility.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QLabel>
#include <QtGui/QPixmap>
#include <QtGui/QPushButton>
#include <QtGui/QTextEdit>

// svn
#include <svn_version.h>

// apr
#include <apr_version.h>
#include <apu_version.h>
#ifdef _WIN32
#include <api_version.h>
#endif

#include <openssl/opensslv.h>

#ifdef HAVE_DB_H
// berkeley db
#include <db.h>

#define DB_VER_NUM STRINGIFY(DB_VERSION_MAJOR) \
               "." STRINGIFY(DB_VERSION_MINOR) \
               "." STRINGIFY(DB_VERSION_PATCH)
#endif // HAVE_DB_H

///////////////////////////////////////////////////////////////////////////////

QString getOpenSSLVersion()
{
  unsigned long openssl = OPENSSL_VERSION_NUMBER;

  // MNNFFPPS: major minor fix patch status
  int major  =  (openssl & 0xf0000000) >> 28;
  int minor  =  (openssl & 0x0ff00000) >> 20;
  int fix    =  (openssl & 0x000ff000) >> 12;
  int patch  = ((openssl & 0x00000ff0) >> 4) + 0x60;
  //int status =  (openssl & 0x0000000f);

  return QString("%1.%2.%3%4").arg(major).arg(minor).arg(fix).arg((char)patch);
}

///////////////////////////////////////////////////////////////////////////////

AboutDialog::AboutDialog( QWidget *parent )
: super(parent)
{
  QPixmap logo;
  QString sname;

  if( getLongAppName() == "subcommander" )
  {
    sname = _q("subcommander");

    setWindowTitle( _q("subcommander:about") );
    logo = QPixmap(":/LogoBanner_400x80_subcommander.png");
  }
  else
  {
    sname = _q("submerge");
    setWindowTitle( _q("submerge:about") );
    logo = QPixmap(":/LogoBanner_400x80_submerge.png");
  }

  QVBoxLayout *vbl = new QVBoxLayout(this/*,0,5*/);
  vbl->setMargin(3);
  {
    QLabel *lp = new QLabel(this);
    vbl->addWidget(lp,0);
    {
      lp->setPixmap(logo);
      lp->setFixedSize(logo.size());
    }

    QString about;
    about += sname + " " SUBCOMMANDER_VERSION "\n\n";
#ifdef SUBCOMMANDER_SPECIALBUILD
    about += SUBCOMMANDER_SPECIALBUILD_DESCRIPTION "\n\n";
#endif // SUBCOMMANDER_SPECIALBUILD
    about += _q("Copyright 2003-2008 Martin Hauner");
    about += "\n";
    about += "http://subcommander.tigris.org" "\n\n";
    about += _q("for feedback or questions write to""\n"
             "dev@subcommander.tigris.org");

    QLabel *l = new QLabel(this);
    vbl->addWidget(l,0);
    l->setMargin(10);
    l->setText( about );
    l->setWordWrap(true);
    l->setAlignment( Qt::AlignCenter );
    l->setFrameStyle( QFrame::Box | QFrame::Sunken );
    l->setTextInteractionFlags( Qt::TextSelectableByKeyboard | Qt::TextSelectableByMouse );
    l->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Fixed) );

    QString about2 = 
      "<qt>";

    QString gnu = "<center><img src=\"";
    gnu += getIconDir() + "GNU.png";
    gnu += "\"></center>";

    about2 +=
       "<table border=0 width=100% cellspacing=5 cellpadding=0>"
        "<tr bgcolor=#1B0A72>"
         "<td align=center><font color=#ffffff>";
    about2 += _q("License");
    about2 += "<font></td>"
        "</tr>"
        "<tr>"
        " <td>";

    about2 += gnu +
        " </td>"
        "</tr>"
        "<tr>"
         "<td>"
          "<p align=center>";
    about2 += _q(
            "Subcommander is free software; you can redistribute it and/or modify it "
            "under the terms of the  GNU General Public License as published  by the "
            "Free Software Foundation; either version 2 of  the License, or (at your "
            "option) any later version.");
    about2 += 
          "</p>"
          "<p align=center>";
    about2 += _q(
            "You should have received a copy of the GNU General Public License along "
            "with Subcommander; if not, write to the Free Software Foundation, Inc., "
            "59 Temple Place  - Suite 330, Boston, MA  02111-1307, USA.");
    about2 +=
          "</p>"
          "<p align=center>";
    about2 += _q(
            "Subcommander is distributed  in the hope  that it will  be useful,  but "
            "WITHOUT  ANY   WARRANTY;  without    even   the   implied  warranty  of "
            "MERCHANTABILITY  or  FITNESS  FOR A PARTICULAR  PURPOSE.   See the  GNU "
            "General Public License for more details.");
    about2 +=
          "</p>"
          "<p align=center>";
    about2 += _q(
            "In  addition,  as  a  special  exception,  the  copyright holder  gives "
            "permission  to link the code  of this program  with the  Qt library (or "
            "with  modified versions  of Qt that use the  same license as  Qt),  and "
            "distribute  linked combinations including the  two.  You  must obey the "
            "GNU General Public License   in all respects  for all of  the code used "
            "other than Qt. ");
    about2 +=
          "</p>"
         "</td>"
        "</tr>"
       "</table>";

       about2 +=
       "<table border=0 width=100% cellspacing=5 cellpadding=0>";
#if 0
        "<tr bgcolor=#1B0A72>"
        "<td align=center colspan=2><font color=#ffffff>" +sname+ "<font></td>"
        "</tr>"
        "<tr bgcolor=#1B0A72>"
        "<td align=center colspan=2><font color=#ffffff>Author<font></td>"
        "</tr>"
        //"<tr>""<td align=center colspan=2>"/*"written by"*/"</td>""</tr>"
        "<tr>""<td align=center colspan=2>Martin Hauner</td>""</tr>"
        //"<tr>""<td align=center colspan=2>"/*" * * * "*/"</td>""</tr>"
        // add contributors here..
        "<tr>""<td align=center colspan=2>with contributions from:</td>""</tr>"
        "<tr>""<td align=center colspan=2>any volunteers?</td>""</tr>"
        "<tr>"
         "<td align=right>name</td>""<td align=left>contributions</td>"
        "</tr>"
        "<tr>""<td align=center colspan=2> * * * </td>""</tr>"
#endif

        // my current understanding of the open source lincenses is that you 
        // do not have to include the "This product includes software developed by ..."
        // clause if you only use the api and do not copy any source from it to your
        // own project.

       about2 +=
        "<tr bgcolor=#1B0A72>"
        "<td align=center colspan=2><font color=#ffffff>";
       about2 += _q("Libraries");
       about2 += "<font></td>"
        "</tr>"
        "<tr>"
         "<td align=center colspan=2>";

       if( getLongAppName() == "subcommander" )
       {
         about2 += _q("subcommander is using the following libraries:");
       }
       else
       {
         about2 += _q("submerge is using the following libraries:");
       }

       about2 +=
         "</td>"
        "</tr>"
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>"
        "<tr>"
         "<td align=right>" "Qt " QT_VERSION_STR  "</td>"
         "<td align=left >" "http://www.trolltech.com" "</td>"
        "</tr>"
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>"
        "<tr>"
         "<td align=center colspan=2>"
          "This product includes software developed by<br>"
          "CollabNet (http://www.Collab.Net/):"
         "</td>"
        "</tr>"
        "<tr>"
         "<td align=right width=50%>" "subversion " SVN_VERSION       "</td>"
         "<td align=left  width=50%>" "http://subversion.tigris.org"  "</td>"
        "</tr>"
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>";

    if( getLongAppName() == "subcommander" )
    {
#ifdef HAVE_DB_H

      about2 +=
        "<tr>"
         "<td align=right>" "Berkeley DB " DB_VER_NUM  "</td>"
         "<td align=left >" "http://www.sleepycat.com" "</td>"
        "</tr>"
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>";

#endif // HAVE_DB_H
    }

    if( getLongAppName() == "subcommander" )
    {
      about2 += 
        "<tr>"
         "<td align=right>" "OpenSSL ";
      about2 += getOpenSSLVersion();
      about2 +=
         "</td>"
         "<td align=left >" "http://www.openssl.org" "</td>"
        "</tr>"
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>";
    }

    about2 +=
        "<tr>"
          "<td align=right>" "apr " APR_VERSION_STRING       "</td>"
          "<td align=left >" "http://apr.apache.org"         "</td>"
        "</tr>"
        "<tr>"
         "<td align=right>" "apr-util " APU_VERSION_STRING  "</td>"
         "<td align=left >" "http://apr.apache.org"         "</td>"
        "</tr>"
#ifdef _WIN32
        "<tr>"
         "<td align=right>" "apr-iconv " API_VERSION_STRING "</td>"
         "<td align=left >" "http://apr.apache.org"         "</td>"
        "</tr>"
#endif
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>";

    if( getLongAppName() == "subcommander" )
    {
      about2 += 
        "<tr>"
         "<td align=right>";
      about2 += getNeonVersion();
      about2 +=
         "</td>"
         "<td align=left>" "http://www.webdav.org"  "</td>"
        "</tr>"
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>";
    }


    about2 +=
        "<tr>"
          "<td align=right>";
    about2 += _q("nuvola (and crystal) icons");
    about2 +=
          "</td>"
          "<td align=left>" "http://www.kdelook.org"  "</td>"
        "</tr>"
        "<tr><td align=center valign=bottom colspan=2> * * * </td></tr>";

    about2 +=
       "</table><br>"
      "</qt>";

    QTextEdit* qtv = new QTextEdit(this);
    vbl->addWidget(qtv,3);
    qtv->setText( about2 );
    qtv->setLineWidth(1);
    qtv->setReadOnly(true);
    qtv->setFrameStyle( QFrame::Box | QFrame::Sunken );
    qtv->viewport()->setBackgroundRole( QPalette::Window );
    qtv->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );
    qtv->setMinimumHeight( (int)(2.5 * lp->height()) );

    setFixedWidth( 406 /* 2*margin + logo width */ );
  }

  QHBoxLayout* hu = new QHBoxLayout;
  vbl->addLayout(hu);
  {
    QPushButton *b = new QPushButton(this);
    b->setDefault(true);
    b->setFocus();
    hu->addWidget(b);
    b->setText(qtf8(_("&Ok")));
    
    hu->addSpacing(getSizeGripSpacing());
    
    QObject::connect( b, SIGNAL(released()), this, SLOT(accept()) );
  }
}

AboutDialog::~AboutDialog()
{
}
