/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWWITHDEEPCHANGE_TEST_H
#define _WCVIEWWITHDEEPCHANGE_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
#include "subcommander/WcViewItem.h"
#include "util/String.h"
class WcViewItemModel;
class WcViewTreeItemModel;
class WcViewTreeProxyModel;

// qt
#include <QtCore/QObject>
#include <QtCore/QModelIndex>


class WcViewWithDeepChange : public QObject, public CppUnit::TestCase 
{
  Q_OBJECT;

  CPPUNIT_TEST_SUITE( WcViewWithDeepChange );

  CPPUNIT_TEST( showAllAfterRootFolderAdd );
  CPPUNIT_TEST( showAllAfterRootFolderFolderAdd );
  CPPUNIT_TEST( showAllAfterRootFolderFoldersAdd );
  CPPUNIT_TEST( showAllAfterRootFolderFolderItemAdd );
  CPPUNIT_TEST( showAllAfterRootFolderFolders1ItemAdd );
  CPPUNIT_TEST( showAllAfterRootFolderFolders2ItemAdd );

  CPPUNIT_TEST( showOnlyRootAfterRootFolderAdd );
  CPPUNIT_TEST( showOnlyRootAfterRootFolderFolderAdd );
  CPPUNIT_TEST( showOnlyRootAfterRootFolderFoldersAdd );
  CPPUNIT_TEST( showPathToModifiedAfterRootFolderFolderItemAdd );
  CPPUNIT_TEST( showPathToModifiedAfterRootFolderFolders1ItemAdd );
  CPPUNIT_TEST( showPathToModifiedAfterRootFolderFolders2ItemAdd );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void showAllAfterRootFolderAdd();
  void showAllAfterRootFolderFolderAdd();
  void showAllAfterRootFolderFoldersAdd();
  void showAllAfterRootFolderFolderItemAdd();
  void showAllAfterRootFolderFolders1ItemAdd();
  void showAllAfterRootFolderFolders2ItemAdd();

  void showOnlyRootAfterRootFolderAdd();
  void showOnlyRootAfterRootFolderFolderAdd();
  void showOnlyRootAfterRootFolderFoldersAdd();
  void showPathToModifiedAfterRootFolderFolderItemAdd();
  void showPathToModifiedAfterRootFolderFolders1ItemAdd();
  void showPathToModifiedAfterRootFolderFolders2ItemAdd();

private:
  void setup( long idx, const char* path, bool dir, bool changed );

  void insert( WcViewItemModel* model, long dataIdx );
  void assertIndex( const QModelIndex& idx, const char* expected );

  WcViewTreeItemModel*  _model;
  WcViewTreeProxyModel* _proxy;

  WcViewItems _items[10];
};

#endif // _WCVIEWWITHDEEPCHANGE_TEST_H
