/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BASEMODEL_H
#define _SC_BASEMODEL_H

// sc
class ScModel;
class Project;
class CopyParam;
class DiffParam;
class LogParam;
class CatParam;
class CheckoutParam;
class MergeParam;
class MoveParam;
class PropSetRevParam;
class BlameParam;
class ExportParam;
class CmdResultCallback;
class LockParam;
class UnlockParam;
class DeleteParam;
class InfoParam;

/**
 * base class for RepositoryModel and WcModel.
 */
class BaseModel
{
public:
  BaseModel( ScModel* model );
  virtual ~BaseModel();

  void copy( CopyParam*, CmdResultCallback* );
  void diff( DiffParam*, CmdResultCallback* );
  void log( LogParam*, CmdResultCallback* );
  void cat( CatParam*, CmdResultCallback* );
  void checkout( CheckoutParam*, CmdResultCallback* );
  void move( MoveParam*, CmdResultCallback* );
  void propsetrev( PropSetRevParam*, CmdResultCallback* );
  void blame( BlameParam*, CmdResultCallback* );
  void exportx( ExportParam*, CmdResultCallback* );
  void lock( LockParam*, CmdResultCallback* );
  void unlock( UnlockParam*, CmdResultCallback* );
  void remove( DeleteParam*, CmdResultCallback* );
  void merge( MergeParam*, CmdResultCallback* );
  void info( InfoParam*, CmdResultCallback* );

  void removeProject( Project* );
  void reorderProjects( Project* src, Project* dst );
  void saveProject( Project* );

  bool isCmdRecursive();
  void setCmdRecursive(bool b);
  bool isCmdForce();
  void setCmdForce(bool b);

  virtual bool isRepository() const = 0;
  virtual bool isWorkingCopy() const = 0;

  void setDrag( bool );
  bool isDragging() const;

  ScModel* getModel();

protected:
  ScModel* _model;
  bool     _drag;
};

#endif // _SC_BASEMODEL_H
