/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "MkdirDialog.h"
#include "Settings.h"
#include "sublib/Gui.h"
#include "sublib/settings/LayoutSettings.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QToolTip>
#include <Qt3Support/Q3GroupBox>



MkdirDialog::MkdirDialog( QWidget *parent )
: super( parent, NULL, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu )
{
  setName( "MkdirDialog" );
  setCaption( _q("subcommander:mkdir") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    Q3GroupBox* gb = new Q3GroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("enter folder name... ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QGridLayout* gl = new QGridLayout(vbl,2,2);
    gl->setMargin(0);
    gl->setRowStretch( 1, 1 );
    {
      {
        QLabel* l = new QLabel(this);
        _edit     = new QLineEdit(this);

        l->setBuddy(_edit);
        l->setText( _q("&folder name:") );
        _edit->setMinimumWidth( _edit->sizeHint().width()*3 );

        gl->addWidget(l,0,0);
        gl->addWidget(_edit,0,1); 

        connect( _edit, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );

        QToolTip::add( _edit, _q("the name of the folder you want to create.") );
      }
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);
      
      hu->addSpacing(getSizeGripSpacing());

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  Settings s;
  resize( s.layout().getSize( name(), QSize(350,300) ) );

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

MkdirDialog::~MkdirDialog()
{
  Settings s;
  s.layout().setSize( name(), geometry().size() );
}

QString MkdirDialog::getFolder()
{
  return _edit->text();
}

void MkdirDialog::checkOk( const QString& text )
{
  QString wc = _edit->text();

  if( ! wc.isEmpty() )
  {
    _ok->setEnabled(true);
  }
  else
  {
    _ok->setEnabled(false);
  }
}
