/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SSLSERVERTRUSTPROMPTDIALOG_H
#define _SC_SSLSERVERTRUSTPROMPTDIALOG_H

// sc
#include "svn/AuthPromptProvider.h"

// qt
#include <QtGui/QDialog>
class QCheckBox;


class SslServerTrustPromptDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  SslServerTrustPromptDialog( const char* realm, unsigned long failures,
    const svn::AuthPromptProvider::sslServerCertInfo& certinfo, bool maySave,
    QWidget *parent = 0, const char *name=0 );
  virtual ~SslServerTrustPromptDialog();

  unsigned long getFailures() const;
  bool          getSave() const;

public slots:
  void acceptPermanently();
  void acceptTemporarily();
  void reject();

private:
  unsigned long _failures;
  bool          _save;
};

#endif // _SC_SSLSERVERTRUSTPROMPTDIALOG_H

