/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCSTATUSINFO_H
#define _SC_WCSTATUSINFO_H

// sc
#include "svn/svn.h"
#include "svn/WcStatusTypes.h"
#include "util/String.h"


class WcStatusInfo
{
public:
  WcStatusInfo( const sc::String& path, const svn::Date& date, const svn::WcStatuss& statuss );

  const sc::String& getPath() const;
  const svn::Date&  getDate() const;
  const svn::WcStatuss& getWcStatuss() const;

  unsigned long getAge() const;

  bool isEmpty() const;
  void operator=( const WcStatusInfo& );
  bool operator==( const WcStatusInfo& );

private:
  sc::String     _path;
  svn::Date      _date;
  svn::WcStatuss _statuss;
};


#endif //  _SC_WCSTATUSINFO_H
