/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_FONTSETTINGSWIDGET_H
#define _SC_FONTSETTINGSWIDGET_H

// sc
#include "sublib/settings/SettingsWidget.h"

// qt
#include <QtGui/QFont>
class QLineEdit;


class FontSettingsWidget : public SettingsWidget
{
  typedef SettingsWidget super;
  Q_OBJECT;

public:
  FontSettingsWidget( QWidget *parent = 0 );
  ~FontSettingsWidget();

  void setGeneralFont( const QFont& );
  void setEditorFont( const QFont& );
  const QFont& getGeneralFont();
  const QFont& getEditorFont();

public slots:
  void selectGeneralFont();
  void selectEditorFont();

private:
  QFont      _gFont;
  QLineEdit* _gFamily;
  QLineEdit* _gSize;

  QFont      _eFont;
  QLineEdit* _eFamily;
  QLineEdit* _eSize;
};


#endif // _SC_FONTSETTINGSWIDGET_H
