/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_CLIENTCONTEXT_H
#define _SVN_CLIENTCONTEXT_H

// sc
#include "util/String.h"

// apr
struct apr_pool_t;

// svn
struct svn_client_ctx_t;


namespace svn
{
class AuthPromptProvider;
class CancelBaton;
class NotifyBaton;
class CommitBaton;
class AuthBaton;

/**
 * This class represents subversions svn_client_ctx_t.
 *
 * The implementation of this class is in svn/Client.cpp.
 */
class ClientContext
{
public:
  ClientContext( AuthPromptProvider* pp, CancelBaton* cb, NotifyBaton* nb,
    CommitBaton* cob, const sc::String& diff, const sc::String& merge );
  ~ClientContext();

  CancelBaton* getCancelBaton() const;
  NotifyBaton* getNotifyBaton() const;
  CommitBaton* getCommitBaton() const;

  const sc::String& getDiffCmd() const;
  const sc::String& getMergeCmd() const;

private:
  apr_pool_t*         _pool;
  svn_client_ctx_t*   _context;

  AuthPromptProvider* _authProv;

  sc::String          _diff;
  sc::String          _merge;

  friend class Client;
};

} // namespace

#endif // _SVN_CLIENTCONTEXT_H

