/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_STACKFRAME_H
#define _SC_STACKFRAME_H

// sc
#include "String.h"

// apr
#include <apr.h>

// sys
#include <vector>


enum VariableKind
{
  vkNone,
  vkLocal,
  vkParameter
};

enum VariableType
{
  vtNone,
  vtInt
};

class Variable
{
public:
  Variable(VariableType type, sc::Size size);
  Variable(const Variable& src);
  virtual ~Variable();

  void value( void* val );
  void name( char* name, sc::Size len );
  operator int() const;

public:
  VariableType _type;
  sc::Size     _size;
  void*        _value;
  sc::String   _name;
  VariableKind _kind;
};

typedef std::vector<Variable> Parameters;
typedef std::vector<Variable> Locals;


class Stackframe
{
public:
  Stackframe();

public:
  bool         _error;

  apr_uint64_t _addr;
  apr_uint32_t _addrSeg;
  apr_uint64_t _addrFrame;

  bool         _symbol;
  sc::String   _symbolName;
  apr_uint64_t _symbolDisp;

  bool         _module;
  sc::String   _moduleName;

  bool         _line;
  sc::String   _fileName;
  long         _lineNr;
  long         _lineDisp;

  Parameters   _params;
  Locals       _locals;
};

typedef std::vector<Stackframe>  Stackframes;

#endif // SC_STACKFRAME_H
