#ifndef _SubtitleASS_h
#define _SubtitleASS_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "Document.h"
#include "SubtitleFormat.h"


class SubtitleASS : public SubtitleFormat
{
public:
	SubtitleASS(Document *doc);
	~SubtitleASS();

	/*
	 *
	 */
	bool open(const Glib::ustring &filename, const Glib::ustring &encoding);

	/*
	 *
	 */
	bool save(const Glib::ustring &filename, const Glib::ustring &encoding);

	/*
	 *
	 */
	static Glib::ustring get_name();
	
	/*
	 *
	 */
	static bool check(const std::string &line);

	/*
	 *
	 */
	static Glib::ustring get_extension();
	
protected:

	/*
	 *	READ BLOCK
	 */
	
	/*
	 *	lecture du block [ScriptInfo]
	 */
	bool readScripInfo(std::ifstream &file);

	/*
	 *	lecture du block [V4+ Styles]
	 */
	bool readStyles(std::ifstream &file);

	/*
	 *	lecture du block [Events]
	 */
	bool readEvents(std::ifstream &file);


protected:

	/*
	 *	convertir le temps utiliser par subtitle editor en temps valide pour le format ASS
	 *	0:00:00.000 -> 0:00:00.00
	 */
	Glib::ustring subtitletime_to_ass_time(const SubtitleTime &time);

	/*
	 *	convertir un temps ASS en SubtitleTime (string)
	 */
	Glib::ustring ass_time_to_subtitletime(const Glib::ustring &time);
	
	/*
	 *	convertir une couleur en couleur ASS pour la sauvegarde
	 */
	Glib::ustring color_to_ass_color(const Color& color);

	/*
	 *	convertir une couleur ASS en Color (interne)
	 */
	Color ass_color_to_color(const Glib::ustring &str);




	/*
	 *	
	 */
	std::vector< std::string > build(const std::string &line, unsigned int column);


	/*
	 *
	 */
	std::vector<std::string> build_format(const std::string &text, int column=-1, bool remove_space=false);
	
	
	/*
	 *
	 */
	Glib::ustring clean_style_name(const Glib::ustring &name);



	/*
	 *	-1=true
	 *	0=false
	 */
	bool str2bool(const std::string &str);
	
};

#endif//_SubtitleASS_h

