/*--------------------------------------------------------------*
 *                                                              *
 *         SUFARY --- Suffix Array ΤΥ饤֥       *
 *                                                              *
 *  sufary.h - SUFARY饤֥إåե                   *
 *                                                              *
 *--------------------------------------------------------------*/

#ifndef _SUFARY_H_
#define _SUFARY_H_

#include <sys/types.h>
#include <sys/mman.h>
#ifndef KEYWORD_MAX_LENGTH
#define KEYWORD_MAX_LENGTH 5000
#endif

/* ޥɤ */
typedef enum eresult_{
  CONT,
  FAIL,
  EXIT,
  ERROR
} eresult;

/* 顼 */
typedef enum eerror_ {
  NOERROR,
  COMMAND,
  MEMORY,
  FILEIN,
  FILEOUT,
  STRUCTURE,
  UNKNOWN
} eerror;

/* SUFARY¤ */
typedef struct {
  eerror ee;      /* Х륨顼ɤݻ */
  long arraysize; /* Array 礭 */
  long left;  /* ϰϤκü(ϰϤ¦ؤ)   g_bottom */
  long right;     /* ϰϤαü(ϰϤ¦ؤ)   g_top */
  int txtfd;      /* ƥȥե */
  int aryfd;      /* 쥤ե */
  off_t txtsz;    /* ƥȥեΥ */
  off_t arysz;    /* 쥤եΥ */
  caddr_t txtmap; /* ƥȥեΥޥåץɥ쥹 */
  caddr_t arymap; /* 쥤եΥޥåץɥ쥹 */
  caddr_t aryorig; /* ꥸʥΥ쥤 */
  caddr_t op_result; /* 黻 */
  char filename[256]; /* ե̾(text file) for DEBUG */
  /*ary_sort_t sort; *//* arymapΥȾ */
} SUFARY;



/* DID¤ */
typedef struct {
  eerror ee;      /* Х륨顼ɤݻ */
  char filename[256]; /* ե̾ for DEBUG */
  
  long didsize;   /* DID 礭 */
  int didfd;      /* DIDե */
  off_t didsz;    /* DIDեΥ */
  caddr_t didmap; /* DIDեΥޥåץɥ쥹 */
  long *docid;      /* mmap줿 */

  long doc_start;
  long doc_size;
  long doc_no;
} DID;


/* ץȥ ѥ롼 */
/*** search.c ***/
/* level 1 : ܴؿ */
eresult sa_sel(SUFARY *ary, char *s);
long sa_left(SUFARY *ary);
long sa_right(SUFARY *ary);
char *sa_getblock(SUFARY *ary, long pos, char* d1, char* d2);
char *sa_getline(SUFARY *ary, long pos);
char *sa_getlines(SUFARY *ary, long pos, int B, int A);
char *sa_aryidx2txtptr(SUFARY *ary, long pos);
void sa_reset(SUFARY *ary);

void sa_didsearch(DID *did, long target); /* 981016 */
char *sa_getstr(SUFARY *ary, long from, long size); /* 981021 */
long sa_doc_start(DID *did); /* 981022 */
long sa_doc_size(DID *did);  /* 981022 */
long sa_doc_no(DID *did);    /* 981028 */
long sa_did_size(DID *did);  /* 981028 */

/* level 2 :  */
eresult sa_search(SUFARY *ary, char *s, int keylen, int base_offset);
long sa_aryidx2txtidx(SUFARY *ary, long idx);
char *sa_txtidx2txtptr(SUFARY *ary, long idx);
long *sa_common_prefix_search(SUFARY *ary, char *kw, char we);
void sa_mojibakebousi(char *buf);
void sa_ctrl_code_tubusi(char *buf);
/* level 3 : ԺѤβǽ */
eresult sa_uniq_near(SUFARY *ret, SUFARY *ary1, SUFARY *ary2,
		     int is_near, int width);


/* 켰ؿ : Ver.2.0 ǤϺͽ */
/*long sa_bottom(SUFARY *ary); *//* = sa_left */
/*long sa_top(SUFARY *ary); *//* = sa_right */
/*char *sa_getkatamari(SUFARY *ary,long pos,char* d1,char* d2); =sa_getblock */
/*long sa_arraytotext(SUFARY *ary, long pos); *//* = sa_aryidx2txtidx  */
/*char *sa_gettext(SUFARY *ary, long pos); *//* = sa_aryidx2txtptr */
/*long *sa_morph_search(SUFARY *ary, char *kw, char *we); *//* =sa_c._p._search */


/*** file.c ***/
/* level 1 : ܴؿ  */
SUFARY *sa_openfiles(char *s, char *t);
void sa_closefiles(SUFARY *ary);

DID *sa_opendid(char *fn); /* since 981016 */
void sa_closedid(DID *d);  /* since 981016 */

/* level 2 : ܴؿƤӽФƤؿñΤǻȤȤϤʤ */
eresult sa_opentextfile(SUFARY *ary, char *s);
eresult sa_openarrayfile(SUFARY *ary, char *s);

/*void sa_closetextfile(SUFARY *ary);*/
/*void sa_closearrayfile(SUFARY *ary);*/

#endif /* _SUFARY_H_ */
