/******************************************************************************

  SUFARYDocIDեץ
    Version 1.1 991014

   USAGE:
     mkdid START_TAG [END_TAG] FILE_NAME

   END_TAGꤷʤȡEND_TAGSTART_TAGƱȤߤʤޤ

   DocIDեˤarrayեFILE_NAME.aryפɬ

 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "sufary.h"

#define DEBUGn
#define MODE_ON 1
#define MODE_OFF 0

int quiet_mode = MODE_OFF; /* åϤʤŤ⡼ɡ */

void usage(void);
static int longcomp(long *i,long *j){return(*i - *j);}


/****************************************************************************
 * functions for endian problem
 ***************************************************************************/
static int is_little_endian(void)
{
    int  n = 1;
    char *c;
    
    c = (char *)&n;
    if (*c == 1) {
        return 1;
    } else {
        return 0;
    }
}

static void reverse_byte_order (long *p, int n)
{
    int i, j;
    unsigned char *c, tmp;

    for (i = 0; i < n; i++) {
        c = (unsigned char*)(p + i);
        for (j = 0; j < (sizeof(long) / 2); j++) {
            tmp = *(c + j);
            *(c + j)= *(c + sizeof(long) - 1 - j);
            *(c + sizeof(long) - 1 - j) = tmp;
        }
    }
}


main(int argc, char *argv[])
{
  SUFARY *ary;
  char *pat, *pat2 = NULL, *fname;
  char ofname[1000];
  FILE *of;
  ofname[0] = '\0';

  while (argc > 1){
    if (argv[1][0] == '-')
      switch (argv[1][1]){
      case 'o': /* ϥե̾λ */
        if (argc == 2){ /* ʤȼդʤ */
          fprintf(stderr,"-o <filename> --- ϥե̾\n");
          exit(1);
        }
        strcpy(ofname,argv[2]);
        argc--; argv++;
        break;
      case 'q': /* åϤʤ */
        quiet_mode = MODE_ON;
        break;
      default : /* 顼 */
        fprintf(stderr, "%c: ̵ʥץǤ\n", argv[1][1]);
	usage();
        exit(1);
      }
    else break;
    argc--; argv++;
  }

  if (argc == 4){
    pat = argv[1]; pat2 = argv[2]; fname = argv[3];
  } else if(argc == 3){
    pat = argv[1]; fname = argv[2];
  } else {
    usage(); exit(1);
  }

  /* ե򳫤 */
  if ((ary = sa_openfiles(fname,NULL)) == NULL){
    fprintf(stderr,"file open error : [%s]\n", fname);
    exit(1);
  }

  if(ofname[0] == '\0') sprintf(ofname, "%s.did", fname);
  
  /*  */
  if (sa_sel(ary, pat) == CONT){ /* ɥȳϥ */
    long l = sa_left(ary), r = sa_right(ary), tmp;
    int num = r - l + 1;
    long* rslt;

    rslt = malloc(num * 2 * sizeof(long));

    if((of = fopen(ofname, "w")) == NULL){
      fprintf(stderr,"file open error : [%s]\n", ofname);
      exit(1);
    }
    if(!quiet_mode) fprintf(stderr,"Number of Documents = %d\n", num);
    for (tmp = 0; tmp < num ; tmp++) rslt[tmp] = sa_aryidx2txtidx(ary, l+tmp);
#ifdef DEBUG
    for (tmp = 0; tmp < num; tmp++) printf("%ld\n", rslt[tmp]);
#endif
    sa_reset(ary);

    if(pat2 != NULL){ /* ɥȽλꤵƤ */
      int len_of_pat2 = strlen(pat2);

      if (sa_sel(ary, pat2) != CONT) {
	fprintf(stderr,"pattern \"%s\" can not be found.\n", pat2);
	exit(1);
      }
      l = sa_left(ary); r = sa_right(ary);
      if(num != r - l + 1){
	fprintf(stderr,"number of \"%s\" != number of \"%s\"\n", pat, pat2);
	exit(1);
      }
      for (tmp = 0; tmp < num ; tmp++)
	rslt[num+tmp] = sa_aryidx2txtidx(ary, l+tmp) + len_of_pat2;
    }else{ /* ɥȽλ  ϥ */
      qsort(rslt,(size_t)num,sizeof(long),
	    (int(*)(const void*,const void*))longcomp);
      for (tmp = 0; tmp < num-1 ; tmp++) rslt[num+tmp] = rslt[tmp+1];
      rslt[num*2-1] = (long)ary->txtsz;
    }

#ifdef DEBUG
    for (tmp = num; tmp < num*2; tmp++) printf("%ld\n", rslt[tmp]);
#endif
    if(!quiet_mode) fprintf(stderr,"sorting...\n");    
    qsort(rslt,(size_t)(num*2),sizeof(long),(int(*)(const void*,const void*))longcomp);
#ifdef DEBUG
    for (tmp = 0; tmp < num*2; tmp++) printf("%ld\n", rslt[tmp]);
#endif

    if(!quiet_mode) fprintf(stderr,"writting...\n");    

    if (is_little_endian())
	reverse_byte_order(rslt, num * 2);

    fwrite(rslt, 1, num*2* sizeof(long), of);
    if(!quiet_mode) fprintf(stderr,"done.\n");
    close(of);
    free(rslt);
  } else 
    fprintf(stderr,"pattern \"%s\" can not be found.\n", pat);

  sa_closefiles(ary);  /* եĤ */
}


/******************
  usage --- Ȥ
 ******************/
void usage(void){
  fprintf(stderr, "\n"
	  "Version 1.1 991014\n\n"
	  "USAGE\n"
	  "  mkdid [ -q ] [ -o FILE_NAME ] START_TAG [ END_TAG ] FILE_NAME\n"
	  "\n"
          "OPTION\n"
          "  -o FILE_NAME  : ϥե\n"
          "  -q            : åʤ\n"
	  "\n"
          );
}

