//-*- c++ -*-
#ifdef __Char__
#else
#define __Char__

#define is_EUC_pref(x) ((x) & 0x80)
// #define is_EUC(x)      (*(x) & 0x80)
// #define is_kanaH(x) (*(x) == 0xA4)
// #define is_kanaK(x) (*(x) == 0xA5)
#define is_EUC(x)      ((x) & 0x8000)
#define is_kanaH(x) ((x) >= 0xA400 && (x) < 0xA500)
#define is_kanaK(x) ((x) >= 0xA500 && (x) < 0xA600)
#define is_TEN(x)   ((x) > 0xA1A1 && (x) < 0xA1A6)
#define is_KUTEN(x) ((x) == 0xA1A5 || (x) == 0xA1A3)
#define is_kakko(x) ((x) > 0xA1C9 && (x) < 0xA1DC && !((x) & 0x0001))
#define is_kokka(x) ((x) > 0xA1C9 && (x) < 0xA1DC && ((x) & 0x0001))
#define is_space(x) ((x) == 0x2000 || (x) == 0x0900 || (x) == 0xA1A1)
#define is_Space(x) ((x) == 0xA1A1)
#define is_EOS(x)   ((x) == 0x0000)
#define is_Same0(x,y)  (((*x) == (*y))&&((*(x+1) == *(y+1))))

#define C_EUC 0x8000
#define C_ASCII 0x4000

class Char {
    union {
	unsigned short int d;
	struct {
	    unsigned char h;
	    unsigned char l;
	} c;
    } C;
    // | . . | | . . | | . . | | . . |
    // E A             s ( ) t - K k h
//    unsigned int codev;
//    void gen_code(void);
  public:
    Char() {C.d = 0;}

    inline int operator==(char x){return ((C.c.h == x)? 1 : 0);}
    inline int operator!=(char x){return ((C.c.h != x)? 1 : 0);}
    inline int operator==(char* s)
        {return ((C.c.h == *s && C.c.l == *(s+1))? 1 : 0);}
    inline int operator!=(char* s)
        {return ((C.c.h == *s && C.c.l == *(s+1))? 0 : 1);}
    inline int operator==(Char& x)
        {return ((C.d == x.C.d)? 1:0);}
    inline int operator!=(Char& x)
        {return ((C.d == x.C.d)? 0:1);}
    inline int operator>(Char& x) {return ((C.d > x.C.d)? 1:0);}
    inline int operator<(Char& x) {return ((C.d < x.C.d < 0)? 1:0);}
    inline int operator>=(Char& x) {return ((C.d >= x.C.d)? 1:0);}
    inline int operator<=(Char& x) {return ((C.d <= x.C.d)? 1:0);}
    Char& operator=(char);
    Char& operator=(char*);
    Char& operator=(Char&);
//    inline unsigned int code(void) {return codev;}

    inline unsigned char upper(void) {return C.c.h;}
    inline unsigned char lower(void) {return C.c.l;}
    inline unsigned short integer(void) {return C.d;}
    
    friend ostream& operator<<(ostream&, Char&);
    friend istream& operator>>(istream&, Char&);
    inline friend int strcmp(Char&, Char&);
};

int strcmp(Char& a, Char& b)
{
    return (a.C.d - b.C.d);
}


class CharStr {
    Char* str;
    int   len;
    int   max;
  public:
    CharStr()  {max = len = -1; str = NULL;}
    ~CharStr() {delete str;}
    CharStr(int n) {len = 0; max = n; str = new Char[max];}

    inline Char& operator[](int x) {return str[x];}
    inline int length(void) {return len;}
    inline int over_flow(void) {return (len >= max);}
    
    CharStr& operator=(char*);
    friend istream& operator>>(istream&, CharStr&);
    friend ostream& operator<<(ostream&, CharStr&);
};

#endif
