#!/usr/bin/env ruby

$KCODE= 'e'

require '../src/suikyo'

def main
  suikyo = Suikyo.new
  tables = ARGV.empty? ? "romaji" : ARGV
  tables.each {|table|
    suikyo.table.loadfile(table, "../../conv-table/")
  }

  loop {
    print "> "
    line = $stdin.gets
    line.chomp!
    (base, pat) = suikyo.convert(line)
    puts "==== [Suikyo#convert]"
    puts base
#    puts
#    puts "----"
#    puts pat
    
   (base, pats) = suikyo.expand(line)
   puts "==== [Suikyo#expand]"
   puts base
   puts "----"
   pats.each {|conv|
     puts conv
   }

#    puts "==== [Suikyo#valid?]"
#    if suikyo.valid?(line) then
#      puts "valid"
#    else
#      puts "invalid"
#    end
  }
end

main

