#include <Python.h>
#include <kapplication.h>
#include <kconfig.h>
#include "karambasessionmanaged.h"
#include "karamba.h"
#include "qwidgetlist.h"




bool KSessionManaged::saveState( QSessionManager& sm ) {
  KConfig* config = kapp->sessionConfig();
  
  config->setGroup("General Options");
  
  QString openThemes="";
  
  QWidgetList  *list = QApplication::allWidgets();
  QWidgetListIt it( *list );         // iterate over the widgets
  QWidget * w;
  while ( (w=it.current()) != 0 ) {  // for each widget...
    ++it;
    if (QString(w->name()) == "karamba") {
      karamba* k = (karamba*) w;
      openThemes += QFileInfo(k->themeFile).absFilePath();
      openThemes += ";";
    } else {
    }
  }
  delete list;                      // delete the list, not the widgets


  config->writeEntry("OpenThemes", openThemes);

  
  return true;
}

bool KSessionManaged::commitData( QSessionManager& sm ) {
 
  return true;
}
