/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "memsensor.h"
#include <qfile.h>
#include <qtextstream.h>
#include <qstring.h>
#include <qregexp.h>
MemSensor::MemSensor(int msec) : Sensor(msec)
{
    readValues();
}
MemSensor::~MemSensor()
{}


int MemSensor::getMemTotal()
{
    QRegExp rx( "MemTotal:\\s*(\\d+)" );
    rx.search( meminfo );
    return ( rx.cap(1).toInt() );
}

int MemSensor::getMemFree()
{
    QRegExp rx( "MemFree:\\s*(\\d+)" );
    rx.search( meminfo );
    return ( rx.cap(1).toInt() );
}


int MemSensor::getBuffers()
{
    QRegExp rx( "Buffers:\\s*(\\d+)" );
    rx.search( meminfo );
    return ( rx.cap(1).toInt() );
}

int MemSensor::getCached()
{
    QRegExp rx1( "Cached:\\s*(\\d+)" );
    QRegExp rx2( "SwapCached:\\s*(\\d+)" );
    rx1.search( meminfo );
    rx2.search( meminfo );
    return ( rx1.cap(1).toInt() + rx2.cap(1).toInt() );
}


int MemSensor::getSwapTotal()
{
    QRegExp rx( "SwapTotal:\\s*(\\d+)" );
    rx.search( meminfo );
    return ( rx.cap(1).toInt() );
}

int MemSensor::getSwapFree()
{
    QRegExp rx( "SwapFree:\\s*(\\d+)" );
    rx.search( meminfo );
    return ( rx.cap(1).toInt() );
}


void MemSensor::readValues()
{
    QFile file("/proc/meminfo");
    QString line;
    if ( file.open(IO_ReadOnly | IO_Translate) )
    {
        QTextStream t( &file );        // use a text stream
        meminfo = t.read();
        file.close();
    }
}

void MemSensor::update()
{
    readValues();
    QString format;
    SensorParams *sp;
    Meter *meter;
    QObjectListIt it( *objList );

    int totalMem = getMemTotal();
    int usedMem = totalMem - getMemFree();
    int usedMemNoBuffers =  usedMem - getBuffers() - getCached();
    int totalSwap = getSwapTotal();
    int usedSwap = totalSwap - getSwapFree();

    while (it != 0)
    {
        sp = (SensorParams*)(*it);
        meter = sp->getMeter();
        format = sp->getParam("FORMAT");
        if (format.length() == 0 )
        {
            format = "%um";
        }

        format.replace( QRegExp("%fmb", false), QString::number( (int)(( totalMem - usedMemNoBuffers)/1024.0+0.5)));
        format.replace( QRegExp("%fm", false), QString::number( (int)( ( totalMem - usedMem  )/1024.0+0.5) ));

        format.replace( QRegExp("%umb", false), QString::number( (int)((usedMemNoBuffers)/1024.0+0.5)));
        format.replace( QRegExp("%um", false), QString::number( (int)((usedMem)/1024.0+0.5 )));

        format.replace( QRegExp("%tm", false), QString::number( (int)( (totalMem)/1024.0+0.5)));

        format.replace( QRegExp("%fs", false), QString::number( (int)((totalSwap - usedSwap)/1024.0+0.5)));
        format.replace( QRegExp("%us", false), QString::number( (int)(usedSwap/1024.0+0.5)));
        format.replace( QRegExp("%ts", false), QString::number( (int)(totalSwap/1024.0+0.5)));

        meter->setValue(format);
        ++it;
    }
}

void MemSensor::setMaxValue( SensorParams *sp )
{
    Meter *meter;
    meter = sp->getMeter();
    QString f;
    f = sp->getParam("FORMAT");

    if (f.length() == 0 )
    {
        f = "%um";
    }
    if( f=="%fm" || f== "%um" || f=="%fmb" || f=="%umb" )
        meter->setMax( getMemTotal() / 1024 );

    if( f=="%fs" || f== "%us" )
        meter->setMax( getSwapTotal() / 1024 );
}
