/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef METER_H
#define METER_H

#include <qpixmap.h>
#include <qpainter.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qobject.h>

#include <qfileinfo.h>
class Meter : public QObject
{
Q_OBJECT
public:

  Meter(int ix,int iy,int iw,int ih);
  Meter();
  virtual ~Meter();
  int getX();
  int getY();
  int getWidth();
  int getHeight();
  void setX(int);
  void setY(int);
  void setWidth(int);
  void setHeight(int);

  void setSize(int ix, int iy, int iw, int ih);

  virtual void setMax( int ){}
  virtual void setMin( int ){}

  void setThemePath( QString );

  virtual void mUpdate(QPainter *)=0 ;

  virtual void setValue(int){}
  virtual void setValue(QString){}

  void show() { hidden = 0; };
  void hide() { hidden = 1; };

  QRect getBoundingBox();

  // true when given coordinate point is inside the meters
  // active reagion and meter is enabled
  virtual bool insideActiveArea(int, int);

  // returns true when callback meterClicked should be called.
  virtual bool click( QMouseEvent* );

  void setEnabled(bool);
  bool isEnabled();

  /*
  void setOnClick( QString );
  void setOnMiddleClick( QString );
  */

protected: // Protected attributes
  QString themePath;

  QRect boundingBox;

  // Actions to execute when clicked on meter
  QString leftButtonAction;
  QString middleButtonAction;
  QString rightButtonAction;

  bool clickable;
  int hidden;
   
};
#endif // METER_H
