//  $Id: player_kart.hpp 1034 2007-05-06 13:37:39Z hiker $
//
//  SuperTuxKart - a fun racing game with go-kart
//  Copyright (C) 2004-2005 Steve Baker <sjbaker1@airmail.net>
//  Copyright (C) 2006 Joerg Henrichs, Steve Baker
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef HEADER_PLAYERKART_H
#define HEADER_PLAYERKART_H

#include "kart.hpp"
#include "player.hpp"

class Player;

/** PlayerKart manages control events from the player and moves
    them to the Kart */
class PlayerKart : public Kart
{
private:
    int m_steer_val, m_accel_val;

    Player *m_player;
    float   m_penalty_time;
    // This field saves all currently pressed keys for each action. This is used
    // to solve problems like: press left, press right, release right --> 
    // the kart should in this case steer left.
    int     m_action_keys_values[KC_FIRE+1];

    void smoothSteer(float dt, bool left, bool right);
public:
    PlayerKart(const KartProperties *kart_properties,
               int position, Player *_player,
               sgCoord init_pos) :
        Kart(kart_properties, position, init_pos), m_player(_player),
        m_penalty_time(0.0)         {reset(); }

    int     earlyStartPenalty () {return m_penalty_time>0; }
    Player* getPlayer         () {return m_player;        }
    void    update            (float);
    void    addMessages       ();
    void    action            (KartActions action, int value, bool isKeyboard);
    void    forceCrash        ();
    void    handleZipper      ();
    void    collectedHerring  (Herring* herring);
    int     isPlayerKart      () const {return 1;}

    void    reset();
};

#endif

/* EOF */
