#
# make_wb_bundle.py
#
import bundlebuilder
import sys
import wx

# workbench sources
sys.path.append( '../../Source' )
# the pysvn package
sys.path.append( '../../../Extension/Source' )

# Create the AppBuilder
myapp = bundlebuilder.AppBuilder (verbosity=1)

# Tell it where to find the main script - the one that loads on startup
myapp.mainprogram = '../../Source/wb_main.py'
myapp.standalone = 1
myapp.name = 'WorkBench.app'
myapp.iconfile = '../../Source/wb.icns'

# create the bundle here
myapp.builddir = sys.argv[1]

# includePackages forces certain packages to be added to the app bundle
#myapp.includePackages.append("Menu")

# Here you add supporting files and/or folders to your bundle
#myapp.resources.append(os.path.join(packageroot,"icons" ))

# bundlebuilder does not yet have the capability to detect what shared  libraries
# are needed by your app - so in this case I am adding the wxPython  libs manually

wx_ver = '%d.%d.%d.%d%s' % wx.VERSION
wx_3ver = '%d.%d.%d' % wx.VERSION[0:3]

myapp.libs.append( "/usr/local/lib/wxPython-unicode-%s/lib/libwx_macud-%s.dylib" % (wx_ver, wx_3ver) )
myapp.libs.append( "/usr/local/lib/wxPython-unicode-%s/lib/libwx_macud_gl-%s.dylib" % (wx_ver, wx_3ver) )
myapp.libs.append( "/usr/local/lib/wxPython-unicode-%s/lib/libwx_macud_gizmos-%s.dylib" % (wx_ver, wx_3ver) )
myapp.libs.append( "/usr/local/lib/wxPython-unicode-%s/lib/libwx_macud_stc-%s.dylib" % (wx_ver, wx_3ver) )
myapp.libs.append( "/usr/local/lib/wxPython-unicode-%s/lib/libwx_macud-%s.r" % (wx_ver, wx_3ver) )
myapp.libs.append( "/usr/local/lib/wxPython-unicode-%s/lib/libwx_macud-%s.rsrc" % (wx_ver, wx_3ver) )

# Here we build the app!
myapp.setup()
myapp.build()
