'''
 ====================================================================
 Copyright (c) 2003-2005 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_subversion_annotate.py

'''
import wx
import wb_images
import time

class AnnotateFrame(wx.Frame):
    def __init__( self, app, project_info, filename, annotation ):
        wx.Frame.__init__( self, None, -1, "Annotation of %s" % filename )

        self.panel = AnnotatePanel( self, app, project_info, filename, annotation )

        # Set the application icon
        self.SetIcon( wb_images.getAppIconIcon() )

        wx.EVT_CLOSE( self, self.OnCloseWindow )

    def OnCloseWindow( self, event ):
        self.Destroy()


class AnnotatePanel(wx.Panel):
    col_line = 0
    col_revision = 1
    col_author = 2
    col_date = 3
    col_text = 4

    def __init__( self, parent, app, project_info, filename, annotation ):
        wx.Panel.__init__( self, parent, -1 )

        self.app = app
        self.project_info = project_info
        self.filename = filename
        self.annotation = annotation

        self.id_list = wx.NewId()

        self.v_sizer = wx.BoxSizer( wx.VERTICAL )

        self.list_ctrl = wx.ListCtrl( self, self.id_list, wx.DefaultPosition, wx.DefaultSize, wx.LC_REPORT|wx.NO_BORDER)

        self.list_ctrl.InsertColumn( self.col_line, "Line")
        self.list_ctrl.InsertColumn( self.col_revision, "Revision")
        self.list_ctrl.InsertColumn( self.col_author, "Author")
        self.list_ctrl.InsertColumn( self.col_date, "Date")
        self.list_ctrl.InsertColumn( self.col_text, "Text")

        char_width = 9
        self.list_ctrl.SetColumnWidth( self.col_line, 6*char_width )
        self.list_ctrl.SetColumnWidth( self.col_revision, 7*char_width )
        self.list_ctrl.SetColumnWidth( self.col_author, 14*char_width )
        self.list_ctrl.SetColumnWidth( self.col_date, 20*char_width )
        self.list_ctrl.SetColumnWidth( self.col_text, 250*char_width )

        self.v_sizer.Add( self.list_ctrl, 2, wx.EXPAND|wx.ALL, 5 )

        wx.EVT_SIZE( self, self.OnSize )

        self.initList()

        self.SetAutoLayout( True )
        self.SetSizer( self.v_sizer )
        self.v_sizer.Fit( self )
        self.Layout()

    #---------- Comment handlers ------------------------------------------------------------
    def OnSize( self, event):
        w,h = self.GetClientSizeTuple()
        self.v_sizer.SetDimension( 0, 0, w, h )

    def initList( self ):
        for index, entry in enumerate( self.annotation ):

            if '\t' in entry['line']:
                column = 1
                char_list = []
                for c in entry['line']:
                    if c == '\t':
                        char_list.append( ' ' )
                        column += 1
                        while (column%8) != 0:
                            column += 1
                            char_list.append( ' ' )
                    else:
                        char_list.append( c )
                        column += 1
                tab_expanded_line = ''.join( char_list )
            else:
                tab_expanded_line = entry['line']

            self.list_ctrl.InsertStringItem( index, str(entry['number']+1) )
            self.list_ctrl.SetStringItem( index, self.col_revision, str(entry['revision'].number) )
            self.list_ctrl.SetStringItem( index, self.col_author, entry['author'] )
            self.list_ctrl.SetStringItem( index, self.col_date, entry['date'] )
            self.list_ctrl.SetStringItem( index, self.col_text, tab_expanded_line )
