#
#	win32.mak WorkBench
#
all: run build_app


APPNAME=wb
APPTYPE=run_w		# run or run_w

PYTHONPATH=$(PYSVN_PYTHONPATH)

SOURCES= \
	wb_app.py \
	wb_dialogs.py \
	wb_diff_difflib.py \
	wb_diff_frame.py \
	wb_diff_images.py \
	wb_diff_main.py \
	wb_diff_processor.py \
	wb_exceptions.py \
	wb_frame.py \
	wb_list_panel.py \
	wb_ids.py \
	wb_main.py \
	wb_platform_specific.py \
	wb_platform_win32_specific.py \
	wb_preferences.py \
	wb_shell_commands.py \
	wb_shell_win32_commands.py \
	wb_source_control_providers.py \
	wb_subversion_utils.py \
	wb_subversion_provider.py \
	wb_subversion_project_info.py \
	wb_subversion_tree_handler.py \
	wb_subversion_list_handler.py \
	wb_subversion_info_dialog.py \
	wb_subversion_properties_dialog.py \
	wb_tree_panel.py \
	wb_version.py

wb.rc: wb.rc.template ..\Builder\version.info
	c:\python23\python ..\Builder\brand_version.py ..\Builder\version.info wb.rc.template

wb_version.py: wb_version.py.template ..\Builder\version.info
	c:\python23\python ..\Builder\brand_version.py ..\Builder\version.info wb_version.py.template


PYCHECKER_OPTIONS=--no-shadowbuiltin


check: checkstop

#
#	Make the run script
#
run: run_$(APPNAME).cmd

SCRIPT_NAME=run_$(APPNAME).cmd
$(SCRIPT_NAME): win32.mak
	echo setlocal > $(SCRIPT_NAME)
	echo set PYTHONPATH=$(PYTHONPATH) >> $(SCRIPT_NAME)
	echo python %CD%\$(APPNAME)_main.py %* >> $(SCRIPT_NAME)
	echo endlocal >> $(SCRIPT_NAME)

clean::
	if exist *.pyc del *.pyc
	if exist bin rmdir bin /s /q
	if exist wb_version.py del wb_version.py

!include <pychecker.mak>
!include <meinc_installer.mak>
