#!/bin/sh 

set -e

# called by uscan with '--upstream-version' <version> <file>
echo "version $2"
package=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
debian_version=`dpkg-parsechangelog | sed -ne 's/^Version: \(.*+dfsg\)-.*/\1/p'`
TAR=${package}_${debian_version}.orig.tar.gz
DIR=${package}-${debian_version}.orig

# clean up the upstream tarball
unzip -d orig $3
mv "$(find orig -maxdepth 1 -type d ! -name orig)" orig/$DIR
GZIP=--best tar -C orig -c -z -f $TAR --exclude doc/javadoc                 \
   --exclude '*.class' --exclude contrib/javahl --exclude contrib/jna       \
   --exclude contrib/junit --exclude contrib/maven --exclude contrib/sqljet \
   --exclude contrib/trilead --numeric-owner --group 0 --owner 0 $DIR
rm -rf $3 orig
