/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _PARSER_DOM_HH
#define _PARSER_DOM_HH


#include <libxml/xpath.h>


struct Tdom_parser {
private:
	std::string get_node_data(xmlNodePtr node);

protected:
	xmlDocPtr doc;
	bool createFromFile(char const *filename);
	bool createFromStreamBz2(FILE *f, char const *filename);
	void clear_dom();
	xmlNodePtr xpath_get_node(std::string expr, xmlXPathContextPtr xpath_ctxt);
	std::string xpath_get_value(std::string expr, xmlXPathContextPtr xpath_ctxt);

public:	
	Tdom_parser();    	
	~Tdom_parser();    	
};


#endif
