/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string>
#include <cstring>
#include <list>
#include <iostream>
#include <cstdio>

#include "basic.hh"
#include "global.hh"

#include "swac_db.hh"
#include "swac_db.inc"
#include "swac_db_lang.inc"

bool Tswac_db::db_check_version() {
	SqlQuery query(&db);
	query.prepare("PRAGMA user_version;");
	return (query.step() == SQLITE_ROW and query.columnInt(0) >= 1);
}

bool Tswac_db::db_open(std::string path) {
	if (db.open(path.c_str())) {
		db_path = path;
		db.exec("PRAGMA synchronous=OFF;");
		return true;
	}
	else
		return false;
}

void Tswac_db::db_clear() {
	print_action(_("CLEAR DATABASE"));
	db.exec("DELETE FROM sounds; DELETE FROM alphaidx; DELETE FROM packages; DELETE FROM packages_available;");
	print_result(true);
}

bool Tswac_db::db_close() {
	return db.close();
}

bool Tswac_db::db_init() {
	print_action(_("INITIALIZE DATABASE"));

	db.exec("PRAGMA user_version=1;");

	db.exec("CREATE TABLE packages ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `packid` varchar(32) NOT NULL default '', \
	  `path` varchar(128) NOT NULL default '', \
	  `version` varchar(32) NOT NULL default '', \
	  `format` varchar(8) NOT NULL default '', \
	  `count` INTEGER NOT NULL default -1, \
	  `name` varchar(64) NOT NULL default '', \
	  `section` varchar(64) NOT NULL default '', \
	  `url` varchar(128) NOT NULL default '', \
	  `authors` varchar(128) NOT NULL default '', \
	  `license` varchar(128) NOT NULL default '', \
	  `organization` varchar(64) NOT NULL default '', \
	  `organization_url` varchar(128) NOT NULL default '', \
	  `description` varchar(256) NOT NULL default '', \
	  `readme` text NOT NULL default '');");

	db.exec("CREATE TABLE packages_available ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `packid` varchar(32) NOT NULL default '', \
	  `path` varchar(128) NOT NULL default '', \
	  `version` varchar(32) NOT NULL default '', \
	  `format` varchar(8) NOT NULL default '', \
	  `count` INTEGER NOT NULL default -1, \
	  `name` varchar(64) NOT NULL default '', \
	  `section` varchar(64) NOT NULL default '', \
	  `url` varchar(128) NOT NULL default '', \
	  `authors` varchar(128) NOT NULL default '', \
	  `license` varchar(128) NOT NULL default '', \
	  `organization` varchar(64) NOT NULL default '', \
	  `organization_url` varchar(128) NOT NULL default '', \
	  `description` varchar(256) NOT NULL default '', \
	  `readme` text NOT NULL default '');");

	db.exec("CREATE TABLE sources ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `path` varchar(128) NOT NULL default '', \
	  `selected` varchar(128) NOT NULL default '');");
	
	db.exec("CREATE TABLE alphaidx ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `lang` varchar(3) NOT NULL default '', \
	  `str` varchar(64) NOT NULL default '', \
	  `packages_idx` INTEGER NOT NULL default 0, \
	  `sounds_idx` INTEGER NOT NULL default 0);");

	db.exec("CREATE TABLE languages ( \
	  `iso_639_3` varchar(3) PRIMARY KEY, \
	  `iso_639_1` varchar(2) NOT NULL default '', \
	  `title` varchar(64) NOT NULL default '');");

	db_init_sounds();
	db_init_languages();
	
	db.exec("CREATE INDEX sounds_lang_text ON sounds(SWAC_LANG, SWAC_TEXT);");
	db.exec("CREATE INDEX sounds_text ON sounds(SWAC_TEXT);");
	db.exec("CREATE INDEX sounds_lang ON sounds(SWAC_LANG);");
	db.exec("CREATE INDEX alphaidx_str ON alphaidx(str);");

	return print_result(true);
}

