/*
 * SwamiUndoFuncs.h - Header file for some functions that handle
 *                    undo state for specific operations.
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMI_UNDO_FUNCS_H__
#define __SWAMI_UNDO_FUNCS_H__

#include <glib.h>
#include <instpatch.h>
#include "SwamiObject.h"
#include "swamidll.h"

enum
{
  SWAMI_UNDO_NONE,		/* NULL undo type */
  SWAMI_UNDO_ITEM_NEW,		/* New item undo type */
  SWAMI_UNDO_ITEM_REMOVE,	/* Remove item undo type */
  SWAMI_UNDO_PROPERTY_CHANGE,	/* single sfont info item */
  SWAMI_UNDO_LAST
};

SWAMI_API extern SwamiUndoTypeInfo swami_undo_type_info [];

SWAMI_API void swami_undo_save_item_new (SwamiObject *swami, IPItem *item);
SWAMI_API void swami_undo_save_item_remove (SwamiObject *swami, IPItem *item);
SWAMI_API void swami_undo_save_property_change (SwamiObject *swami,
						IPItem *item,
						const char *property_name);

#endif
