/* gfxpoly.h 

   Various boolean polygon functions.

   Part of the swftools package.

   Copyright (c) 2005 Matthias Kramm <kramm@quiss.org> 

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef __gfxpoly_h__
#define __gfxpoly_h__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include "../lib/mem.h"
#include "../lib/gfxdevice.h"
#include "../lib/gfxtools.h"

typedef struct _gfxpoly {
} gfxpoly_t;

void gfxpoly_free(gfxpoly_t*);

/* constructors */
gfxpoly_t* gfxpoly_fillToPoly(gfxline_t*line);
gfxpoly_t* gfxpoly_strokeToPoly(gfxline_t*line, gfxcoord_t width, gfx_capType cap_style, gfx_joinType joint_style, double miterLimit);
gfxpoly_t* gfxpoly_createbox(double x1, double y1,double x2, double y2);

/* boolean operations */
gfxpoly_t* gfxpoly_intersect(gfxpoly_t*line1, gfxpoly_t*line2);
gfxpoly_t* gfxpoly_union(gfxpoly_t*line1, gfxpoly_t*line2);

/* other things */
gfxline_t* gfxpoly_to_gfxline(gfxpoly_t*poly);
gfxline_t* gfxline_circularToEvenOdd(gfxline_t*line);

#ifdef __cplusplus
}
#endif

#endif //__gfxpoly_h__

