/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swingwt.applet.Applet;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Graphics;
import swingwt.awt.Insets;
import swingwt.awt.Point;
import swingwt.awt.Rectangle;
import swingwt.awt.Window;
import swingwt.awt.event.FocusEvent;
import swingwt.awt.event.FocusListener;
import swingwt.awt.event.MouseEvent;
import swingwt.awt.event.MouseListener;
import swingwtx.accessibility.AccessibleContext;
import swingwtx.swing.ActionMap;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.InputMap;
import swingwtx.swing.JInternalFrame;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.border.AbstractBorder;
import swingwtx.swing.border.Border;

public class JComponent
extends Container {
    protected Border border = null;
    protected AccessibleContext accessibleContext = null;
    protected boolean descendantHasPeer = false;
    protected Hashtable clientProperties;
    protected boolean opaque = true;
    protected InputMap focusInputMap = null;
    protected InputMap ancestorInputMap = null;
    protected InputMap windowInputMap = null;
    protected ActionMap actionMap = null;
    protected Vector propertyChangeListeners = new Vector();
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    protected InternalFrameSelectionListener internalFrameAdapter = null;
    protected JInternalFrame internalFrameParent = null;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.add(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeListeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.remove(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeListeners.remove(l);
    }

    public void add(Component c, Object layoutModifier) {
        this.checkInternalFrameChild();
        super.add(c, layoutModifier);
    }

    public void add(Component c, Object layoutModifier, int index) {
        this.checkInternalFrameChild();
        super.add(c, layoutModifier, index);
    }

    public Component add(String name, Component c) {
        this.checkInternalFrameChild();
        return super.add(name, c);
    }

    public Component add(Component c) {
        this.checkInternalFrameChild();
        return super.add(c);
    }

    public Component add(Component c, int index) {
        this.checkInternalFrameChild();
        return super.add(c);
    }

    public void remove(Component c) {
        if (this.internalFrameAdapter != null) {
            this.removeFocusListener(this.internalFrameAdapter);
            this.removeMouseListener(this.internalFrameAdapter);
            this.internalFrameAdapter = null;
        }
        super.remove(c);
    }

    public void remove(int index) {
        Component c = (Component)this.comps.get(index);
        this.remove(c);
    }

    protected void checkInternalFrameChild() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof JInternalFrame)) continue;
            this.internalFrameParent = (JInternalFrame)c;
            this.internalFrameAdapter = new InternalFrameSelectionListener();
            this.addMouseListener(this.internalFrameAdapter);
            this.addFocusListener(this.internalFrameAdapter);
            return;
        }
    }

    public void paintImmediately(int x, int y, int w, int h) {
        super.repaint();
    }

    public void paintImmediately(Rectangle r) {
        super.repaint();
    }

    public void repaint(Rectangle r) {
        this.repaint(r.x, r.y, r.width, r.height);
    }

    protected void paintComponent(Graphics g) {
        this.paint(g);
    }

    protected void paintChildren(Graphics g) {
    }

    public void paintBackground(int x, int y, int width, int height) {
        if (this.parent != null && !this.isOpaque()) {
            Dimension size = this.getSize();
            Point location = this.getLocation();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.border != null) {
            this.border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Border getBorder() {
        if (this.border == null) {
            return BorderFactory.createEmptyBorder();
        }
        return this.border;
    }

    public void setBorder(Border b) {
        this.border = b;
        this.invalidate();
    }

    public void setRequestFocusEnabled(boolean b) {
    }

    public void setAutoscrolls(boolean b) {
    }

    public String getToolTipText(MouseEvent e) {
        return this.getToolTipText();
    }

    public Container getTopLevelAncestor() {
        for (Container p = this; p != null; p = p.getParent()) {
            if (!(p instanceof Window) && !(p instanceof Applet)) continue;
            return p;
        }
        return null;
    }

    public Point getToolTipLocation(MouseEvent e) {
        return e.getPoint();
    }

    public boolean getAutoscrolls() {
        return true;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean b) {
        this.opaque = b;
    }

    public boolean isDoubleBuffered() {
        return this.pDoubleBuffered;
    }

    public void setDoubleBuffered(boolean b) {
        this.pDoubleBuffered = b;
    }

    public void scrollRectToVisible(Rectangle aRect) {
    }

    private Dictionary getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable(2);
        }
        return this.clientProperties;
    }

    public void revalidate() {
        this.invalidate();
    }

    public final Object getClientProperty(Object key) {
        this.getClientProperties();
        if (this.clientProperties == null) {
            return null;
        }
        return this.getClientProperties().get(key);
    }

    public Rectangle getVisibleRect() {
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }

    public final void putClientProperty(Object key, Object value) {
        this.getClientProperties();
        if (value == null && this.clientProperties == null) {
            return;
        }
        this.getClientProperties().put(key, value);
    }

    public void setMargin(Insets i) {
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public boolean isValidateRoot() {
        return false;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void setNextFocusableComponent(Component acomponent) {
    }

    public Insets getInsets() {
        final Insets insets = new Insets();
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (JComponent.this.border != null) {
                    if (JComponent.this.border instanceof AbstractBorder) {
                        ((AbstractBorder)JComponent.this.border).getBorderInsets(JComponent.this, insets);
                    } else {
                        Insets borderInsets = JComponent.this.border.getBorderInsets(JComponent.this);
                        insets.left = borderInsets.left;
                        insets.top = borderInsets.top;
                        insets.right = borderInsets.right;
                        insets.bottom = borderInsets.bottom;
                    }
                } else {
                    if (!SwingWTUtils.isSWTControlAvailable((Control)JComponent.this.composite)) {
                        return;
                    }
                    org.eclipse.swt.graphics.Rectangle rect = JComponent.this.composite.getBounds();
                    org.eclipse.swt.graphics.Rectangle client = JComponent.this.composite.getClientArea();
                    insets.left = client.x;
                    insets.top = client.y;
                    insets.right = rect.width - client.width - client.x;
                    insets.bottom = rect.height - client.height - client.y;
                }
            }
        });
        return insets;
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
    }

    public final void setInputMap(int condition, InputMap inputMap) {
        if (condition == 0) {
            this.focusInputMap = inputMap;
        } else if (condition == 1) {
            this.ancestorInputMap = inputMap;
        } else if (condition == 2) {
            this.windowInputMap = inputMap;
        } else {
            throw new IllegalArgumentException("Illegal InputMap type!");
        }
    }

    public final InputMap getInputMap(int condition, boolean create) {
        InputMap inputMap = null;
        if (condition == 0) {
            if (this.focusInputMap == null && create) {
                this.focusInputMap = new InputMap();
            }
            if (this.focusInputMap != null) {
                inputMap = this.focusInputMap;
            }
        } else if (condition == 1) {
            if (this.ancestorInputMap == null && create) {
                this.ancestorInputMap = new InputMap();
            }
            if (this.ancestorInputMap != null) {
                inputMap = this.ancestorInputMap;
            }
        } else if (condition == 2) {
            if (this.windowInputMap == null && create) {
                this.windowInputMap = new InputMap();
            }
            if (this.windowInputMap != null) {
                inputMap = this.windowInputMap;
            }
        } else {
            throw new IllegalArgumentException("Illegal InputMap type!");
        }
        return inputMap;
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public final ActionMap getActionMap() {
        return this.getActionMap(true);
    }

    private final ActionMap getActionMap(boolean create) {
        ActionMap map = null;
        if (this.actionMap != null) {
            map = this.actionMap;
        } else if (create) {
            map = new ActionMap();
        }
        this.actionMap = map;
        return map;
    }

    public void dispose() {
        super.dispose();
    }

    public void setSwingWTParent(Container parent) throws Exception {
        super.setSwingWTParent(parent);
        if (!this.descendantHasPeer) {
            this.ppeer = new Composite(parent.getComposite(), 0);
            this.peer = this.ppeer;
            this.parent = parent;
        }
    }

    protected class InternalFrameSelectionListener
    implements MouseListener,
    FocusListener {
        protected InternalFrameSelectionListener() {
        }

        public void focusGained(FocusEvent e) {
            this.selectFrame();
        }

        public void focusLost(FocusEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            this.selectFrame();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void selectFrame() {
            try {
                if (!JComponent.this.internalFrameParent.getParentPane().useTabbedEmulation) {
                    JComponent.this.internalFrameParent.getParentPane().setSelectedFrame(JComponent.this.internalFrameParent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

