/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.FillLayout;
import swingwt.awt.MenuBar;
import swingwt.awt.Window;
import swingwtx.swing.JButton;
import swingwtx.swing.JLayeredPane;
import swingwtx.swing.JMenuBar;
import swingwtx.swing.JPanel;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JRootPane
extends JPanel {
    public static final int NONE = 0;
    public static final int FRAME = 1;
    public static final int PLAIN_DIALOG = 2;
    public static final int INFORMATION_DIALOG = 3;
    public static final int ERROR_DIALOG = 4;
    public static final int COLOR_CHOOSER_DIALOG = 5;
    public static final int FILE_CHOOSER_DIALOG = 6;
    public static final int QUESTION_DIALOG = 7;
    public static final int WARNING_DIALOG = 8;
    protected int windowDecorationStyle = 0;
    protected Container contentPane = null;
    protected JMenuBar jMenuBar = null;
    protected MenuBar menuBar = null;
    protected JButton defaultButton = null;
    protected Component glassPane = null;
    protected JLayeredPane layeredPane = null;
    protected Window parentWindow = null;

    public JRootPane() {
        this((Window)null);
    }

    public JRootPane(Window parentWindow) {
        this.parentWindow = parentWindow;
        this.setLayout(new RootPaneLayout());
        this.setGlassPane(this.createGlassPane());
        this.setLayeredPane(this.createLayeredPane());
        this.setContentPane(this.createContentPane());
    }

    protected Container createContentPane() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        return content;
    }

    protected Component createGlassPane() {
        return new JPanel();
    }

    protected JLayeredPane createLayeredPane() {
        return new JLayeredPane();
    }

    public int getWindowDecorationStyle() {
        return this.windowDecorationStyle;
    }

    public void setWindowDecorationStyle(int windowStyle) {
        this.windowDecorationStyle = windowStyle;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(Container content) {
        if (this.contentPane != null) {
            this.removeAll();
        }
        this.contentPane = content;
        this.add(this.contentPane);
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public JLayeredPane getLayeredPane() {
        return this.layeredPane;
    }

    public void setGlassPane(Component glassPane) {
        this.glassPane = glassPane;
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        this.layeredPane = layeredPane;
    }

    public void setJMenuBar(final JMenuBar menu) {
        this.jMenuBar = menu;
        try {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    try {
                        menu.setSwingWTParent((Shell)JRootPane.this.parentWindow.getSWTPeer());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMenuBar(MenuBar menu) {
        this.setJMenuBar(menu.getJMenuBar());
        this.menuBar = menu;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenuBar getJMenuBar() {
        return this.jMenuBar;
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(final JButton defaultButton) {
        this.defaultButton = defaultButton;
        defaultButton.setDefaultButtonParent(this);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(JRootPane.this.peer) && defaultButton.getSWTPeer() != null) {
                    JRootPane.this.peer.getShell().setDefaultButton((Button)defaultButton.getSWTPeer());
                }
            }
        });
    }

    public boolean isValidateRoot() {
        return true;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    protected class RootPaneLayout
    extends FillLayout {
        protected RootPaneLayout() {
        }
    }
}

