/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean stippled;
    Cursor clientCursor;
    Cursor resizeCursor;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    int cursorOrientation = 0;
    boolean inEvent = false;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    org.eclipse.swt.graphics.Point adjustMoveCursor() {
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        if (this.parent != null) {
            Rect rect = new Rect();
            OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
            newX += rect.left;
            newY += rect.top;
            int window = OS.GetControlOwner((int)this.parent.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            newX += rect.left;
            newY += rect.top;
        }
        CGPoint pt = new CGPoint();
        pt.x = newX;
        pt.y = newY;
        OS.CGWarpMouseCursorPosition((CGPoint)pt);
        return new org.eclipse.swt.graphics.Point((int)pt.x, (int)pt.y);
    }

    org.eclipse.swt.graphics.Point adjustResizeCursor() {
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            Rect rect = new Rect();
            OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
            newX += rect.left;
            newY += rect.top;
            int window = OS.GetControlOwner((int)this.parent.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            newX += rect.left;
            newY += rect.top;
        }
        CGPoint pt = new CGPoint();
        pt.x = newX;
        pt.y = newY;
        OS.CGWarpMouseCursorPosition((CGPoint)pt);
        if (this.clientCursor == null) {
            Cursor newCursor = null;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 1024: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 16384: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 131072: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 16512: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 132096: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 17408: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                case 131200: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                default: {
                    newCursor = new Cursor(this.display, 5);
                }
            }
            this.display.setCursor(newCursor.handle);
            if (this.resizeCursor != null) {
                this.resizeCursor.dispose();
            }
            this.resizeCursor = newCursor;
        }
        return new org.eclipse.swt.graphics.Point((int)pt.x, (int)pt.y);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        int i = 0;
        while (i < rects.length) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.bounds.width != 0) {
                x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                width = rects[i].width * 100 / this.bounds.width;
            } else {
                width = 100;
            }
            if (this.bounds.height != 0) {
                y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                height = rects[i].height * 100 / this.bounds.height;
            } else {
                height = 100;
            }
            result[i] = new Rectangle(x, y, width, height);
            ++i;
        }
        return result;
    }

    void drawRectangles(int window, Rectangle[] rects, boolean erase) {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            Shell shell = this.parent.getShell();
            shell.update(true);
        } else {
            this.display.update();
        }
        int[] context = new int[1];
        int port = OS.GetWindowPort((int)window);
        Rect portRect = new Rect();
        OS.GetPortBounds((int)port, (Rect)portRect);
        OS.QDBeginCGContext((int)port, (int[])context);
        OS.CGContextScaleCTM((int)context[0], (float)1.0f, (float)-1.0f);
        OS.CGContextTranslateCTM((int)context[0], (float)0.0f, (float)(portRect.top - portRect.bottom));
        CGRect cgRect = new CGRect();
        org.eclipse.swt.graphics.Point parentOrigin = this.parent != null ? this.display.map(this.parent, null, 0, 0) : new org.eclipse.swt.graphics.Point(0, 0);
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            cgRect.x = rect.x + parentOrigin.x;
            cgRect.y = rect.y + parentOrigin.y;
            cgRect.width = rect.width;
            cgRect.height = rect.height;
            if (erase) {
                cgRect.width += 1.0f;
                cgRect.height += 1.0f;
                OS.CGContextClearRect((int)context[0], (CGRect)cgRect);
            } else {
                cgRect.x += 0.5f;
                cgRect.y += 0.5f;
                OS.CGContextStrokeRect((int)context[0], (CGRect)cgRect);
            }
            ++i;
        }
        OS.CGContextSynchronize((int)context[0]);
        OS.QDEndCGContext((int)port, (int[])context);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int length = 0;
        if (this.rectangles != null) {
            length = this.rectangles.length;
        }
        Rectangle[] result = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean open() {
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        cancelled = false;
        this.tracking = true;
        window = this.display.createOverlayWindow();
        OS.ShowWindow((int)window);
        this.drawRectangles(window, this.rectangles, false);
        vStyle = this.style & 1152;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 147456) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        if (OS.StillDown()) {
            pt = new Point();
            OS.GetGlobalMouse((Point)pt);
            cursorPos = new org.eclipse.swt.graphics.Point(pt.h, pt.v);
        } else {
            cursorPos = (this.style & 16) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
        }
        oldX = cursorPos.x;
        oldY = cursorPos.y;
        event = new Event();
        outEvent = new int[1];
        while (this.tracking && !cancelled) {
            block43: {
                status = OS.ReceiveNextEvent((int)0, null, (double)0.0, (boolean)true, (int[])outEvent);
                if (status != 0) continue;
                eventClass = OS.GetEventClass((int)outEvent[0]);
                eventKind = OS.GetEventKind((int)outEvent[0]);
                newX = oldX;
                newY = oldY;
                block0 : switch (eventClass) {
                    case 1836021107: {
                        switch (eventKind) {
                            case 2: 
                            case 5: 
                            case 6: {
                                sizeof = 4;
                                where = new Point();
                                OS.GetEventParameter((int)outEvent[0], (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)where);
                                newX = where.h;
                                newY = where.v;
                                if (newX == oldX && newY == oldY) ** GOTO lbl109
                                oldRectangles = this.rectangles;
                                rectsToErase = new Rectangle[this.rectangles.length];
                                i = 0;
                                while (i < this.rectangles.length) {
                                    current = this.rectangles[i];
                                    rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                                    ++i;
                                }
                                event.x = newX;
                                event.y = newY;
                                if ((this.style & 16) == 0) ** GOTO lbl82
                                this.resizeRectangles(newX - oldX, newY - oldY);
                                this.inEvent = true;
                                this.sendEvent(11, event);
                                this.inEvent = false;
                                if (this.isDisposed()) {
                                    cancelled = true;
                                    break;
                                }
                                draw = false;
                                if (this.rectangles == oldRectangles) ** GOTO lbl74
                                length = this.rectangles.length;
                                if (length == rectsToErase.length) ** GOTO lbl66
                                draw = true;
                                ** GOTO lbl75
lbl66:
                                // 1 sources

                                i = 0;
                                while (i < length) {
                                    if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl71
                                    draw = true;
                                    ** GOTO lbl75
lbl71:
                                    // 1 sources

                                    ++i;
                                }
                                ** GOTO lbl75
lbl74:
                                // 1 sources

                                draw = true;
lbl75:
                                // 4 sources

                                if (draw) {
                                    this.drawRectangles(window, rectsToErase, true);
                                    this.drawRectangles(window, this.rectangles, false);
                                }
                                cursorPos = this.adjustResizeCursor();
                                newX = cursorPos.x;
                                newY = cursorPos.y;
                                ** GOTO lbl107
lbl82:
                                // 1 sources

                                this.moveRectangles(newX - oldX, newY - oldY);
                                this.inEvent = true;
                                this.sendEvent(10, event);
                                this.inEvent = false;
                                if (this.isDisposed()) {
                                    cancelled = true;
                                    break;
                                }
                                draw = false;
                                if (this.rectangles == oldRectangles) ** GOTO lbl103
                                length = this.rectangles.length;
                                if (length == rectsToErase.length) ** GOTO lbl95
                                draw = true;
                                ** GOTO lbl104
lbl95:
                                // 1 sources

                                i = 0;
                                while (i < length) {
                                    if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl100
                                    draw = true;
                                    ** GOTO lbl104
lbl100:
                                    // 1 sources

                                    ++i;
                                }
                                ** GOTO lbl104
lbl103:
                                // 1 sources

                                draw = true;
lbl104:
                                // 4 sources

                                if (draw) {
                                    this.drawRectangles(window, rectsToErase, true);
                                    this.drawRectangles(window, this.rectangles, false);
                                }
lbl107:
                                // 4 sources

                                oldX = newX;
                                oldY = newY;
lbl109:
                                // 2 sources

                                this.tracking = eventKind != 2;
                            }
                        }
                        break;
                    }
                    case 1801812322: {
                        switch (eventKind) {
                            case 1: 
                            case 2: 
                            case 4: {
                                keyCode = new int[1];
                                OS.GetEventParameter((int)outEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
                                modifiers = new int[1];
                                OS.GetEventParameter((int)outEvent[0], (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
                                stepSize = (modifiers[0] & 4096) != 0 ? 1 : 9;
                                xChange = 0;
                                yChange = 0;
                                switch (keyCode[0]) {
                                    case 53: {
                                        cancelled = true;
                                        this.tracking = false;
                                        break;
                                    }
                                    case 36: {
                                        this.tracking = false;
                                        break;
                                    }
                                    case 123: {
                                        xChange = -stepSize;
                                        break;
                                    }
                                    case 124: {
                                        xChange = stepSize;
                                        break;
                                    }
                                    case 126: {
                                        yChange = -stepSize;
                                        break;
                                    }
                                    case 125: {
                                        yChange = stepSize;
                                    }
                                }
                                if (xChange == 0 && yChange == 0) break block43;
                                oldRectangles = this.rectangles;
                                rectsToErase = new Rectangle[this.rectangles.length];
                                i = 0;
                                while (i < this.rectangles.length) {
                                    current = this.rectangles[i];
                                    rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                                    ++i;
                                }
                                newX = oldX + xChange;
                                newY = oldY + yChange;
                                event.x = newX;
                                event.y = newY;
                                if ((this.style & 16) == 0) ** GOTO lbl184
                                this.resizeRectangles(xChange, yChange);
                                this.inEvent = true;
                                this.sendEvent(11, event);
                                this.inEvent = false;
                                if (this.isDisposed()) {
                                    cancelled = true;
                                    break block0;
                                }
                                draw = false;
                                if (this.rectangles == oldRectangles) ** GOTO lbl178
                                length = this.rectangles.length;
                                if (length == rectsToErase.length) ** GOTO lbl170
                                draw = true;
                                ** GOTO lbl179
lbl170:
                                // 1 sources

                                i = 0;
                                while (i < length) {
                                    if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl175
                                    draw = true;
                                    ** GOTO lbl179
lbl175:
                                    // 1 sources

                                    ++i;
                                }
                                ** GOTO lbl179
lbl178:
                                // 1 sources

                                draw = true;
lbl179:
                                // 4 sources

                                if (draw) {
                                    this.drawRectangles(window, rectsToErase, true);
                                    this.drawRectangles(window, this.rectangles, false);
                                }
                                cursorPos = this.adjustResizeCursor();
                                ** GOTO lbl210
lbl184:
                                // 1 sources

                                this.moveRectangles(xChange, yChange);
                                this.inEvent = true;
                                this.sendEvent(10, event);
                                this.inEvent = false;
                                if (this.isDisposed()) {
                                    cancelled = true;
                                    break block0;
                                }
                                draw = false;
                                if (this.rectangles == oldRectangles) ** GOTO lbl205
                                length = this.rectangles.length;
                                if (length == rectsToErase.length) ** GOTO lbl197
                                draw = true;
                                ** GOTO lbl206
lbl197:
                                // 1 sources

                                i = 0;
                                while (i < length) {
                                    if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl202
                                    draw = true;
                                    ** GOTO lbl206
lbl202:
                                    // 1 sources

                                    ++i;
                                }
                                ** GOTO lbl206
lbl205:
                                // 1 sources

                                draw = true;
lbl206:
                                // 4 sources

                                if (draw) {
                                    this.drawRectangles(window, rectsToErase, true);
                                    this.drawRectangles(window, this.rectangles, false);
                                }
                                cursorPos = this.adjustMoveCursor();
lbl210:
                                // 2 sources

                                oldX = cursorPos.x;
                                oldY = cursorPos.y;
                            }
                        }
                    }
                }
            }
            dispatch = true;
            if (this.tracking && !cancelled) {
                if (eventClass == 1836021107) {
                    dispatch = false;
                }
                if (eventClass == 1801812322) {
                    dispatch = false;
                }
            }
            if (dispatch) {
                OS.SendEventToEventTarget((int)outEvent[0], (int)OS.GetEventDispatcherTarget());
            }
            OS.ReleaseEvent((int)outEvent[0]);
            if (this.clientCursor == null || this.resizeCursor != null) continue;
            this.display.setCursor(this.clientCursor.handle);
        }
        if (!this.isDisposed()) {
            this.drawRectangles(window, this.rectangles, true);
        }
        OS.DisposeWindow((int)window);
        this.tracking = false;
        this.display.grabControl = null;
        return cancelled == false;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = newCursor;
        if (newCursor != null && this.inEvent) {
            this.display.setCursor(newCursor.handle);
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

