/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.WorkingSetComparator;
import org.eclipse.ui.internal.WorkingSetMenuContributionItem;
import org.eclipse.ui.internal.actions.ClearWorkingSetAction;
import org.eclipse.ui.internal.actions.EditWorkingSetAction;
import org.eclipse.ui.internal.actions.SelectWorkingSetAction;

public class WorkingSetFilterActionGroup
extends ActionGroup {
    public static final String CHANGE_WORKING_SET = "changeWorkingSet";
    private static final String SEPARATOR_ID = "workingSetGroupSeparator";
    private IWorkingSet workingSet = null;
    private ClearWorkingSetAction clearWorkingSetAction;
    private SelectWorkingSetAction selectWorkingSetAction;
    private EditWorkingSetAction editWorkingSetAction;
    private IPropertyChangeListener workingSetUpdater;
    private int mruMenuCount;
    private IMenuManager menuManager;
    private IMenuListener menuListener;

    public WorkingSetFilterActionGroup(Shell shell, IPropertyChangeListener workingSetUpdater) {
        Assert.isNotNull((Object)shell);
        this.workingSetUpdater = workingSetUpdater;
        this.clearWorkingSetAction = new ClearWorkingSetAction(this);
        this.selectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.editWorkingSetAction = new EditWorkingSetAction(this, shell);
    }

    private void addMruWorkingSetActions(IMenuManager menuManager) {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        List<IWorkingSet> sortedWorkingSets = Arrays.asList(workingSets);
        Collections.sort(sortedWorkingSets, new WorkingSetComparator());
        Iterator<IWorkingSet> iter = sortedWorkingSets.iterator();
        this.mruMenuCount = 0;
        while (iter.hasNext()) {
            IWorkingSet workingSet = iter.next();
            if (workingSet == null) continue;
            WorkingSetMenuContributionItem item = new WorkingSetMenuContributionItem(++this.mruMenuCount, this, workingSet);
            menuManager.insertBefore(SEPARATOR_ID, (IContributionItem)item);
        }
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.removeMenuListener(this.menuListener);
        }
        super.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        this.menuManager = actionBars.getMenuManager();
        this.menuManager.add((IAction)this.selectWorkingSetAction);
        this.menuManager.add((IAction)this.clearWorkingSetAction);
        this.menuManager.add((IAction)this.editWorkingSetAction);
        this.menuManager.add((IContributionItem)new Separator());
        this.menuManager.add((IContributionItem)new Separator(SEPARATOR_ID));
        this.menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkingSetFilterActionGroup.this.removePreviousMruWorkingSetActions(manager);
                WorkingSetFilterActionGroup.this.addMruWorkingSetActions(manager);
            }
        };
        this.menuManager.addMenuListener(this.menuListener);
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    private void removePreviousMruWorkingSetActions(IMenuManager menuManager) {
        int i = 1;
        while (i <= this.mruMenuCount) {
            menuManager.remove(WorkingSetMenuContributionItem.getId(i));
            ++i;
        }
    }

    public void setWorkingSet(IWorkingSet newWorkingSet) {
        IWorkingSet oldWorkingSet = this.workingSet;
        this.workingSet = newWorkingSet;
        this.clearWorkingSetAction.setEnabled(newWorkingSet != null);
        this.editWorkingSetAction.setEnabled(newWorkingSet != null);
        if (this.workingSetUpdater != null) {
            this.workingSetUpdater.propertyChange(new PropertyChangeEvent((Object)this, CHANGE_WORKING_SET, (Object)oldWorkingSet, (Object)newWorkingSet));
        }
    }
}

