/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IWindowTrim;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDragSource;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;

class FastViewBar
implements IWindowTrim {
    private ToolBarManager fastViewBar;
    private Menu fastViewBarMenu;
    private Menu sidesMenu;
    private WorkbenchWindow window;
    private MenuItem restoreItem;
    private IViewReference selection;
    private boolean visible = false;
    private Composite control;
    private GridData toolBarData;
    private static final int HIDDEN_WIDTH = 5;
    private MenuItem showOn;
    private Cursor moveCursor;
    private MenuItem closeItem;
    private MenuItem orientationItem;
    private IntModel side = new IntModel(1024);
    private IntModel currentOrientation = new IntModel(512);
    private RadioMenu radioButtons;
    private IViewReference selectedView;
    private int lastSide;
    private Label fastViewLabel;
    private Label fastViewLabel2;
    private int oldLength = 0;
    private IChangeListener orientationChangeListener = new IChangeListener(){

        public void update(boolean changed) {
            if (changed && FastViewBar.this.selectedView != null) {
                FastViewBar.this.viewOrientation.put(FastViewBar.this.selectedView.getId(), FastViewBar.this.currentOrientation.getState());
                Perspective persp = FastViewBar.this.window.getActiveWorkbenchPage().getActivePerspective();
                IViewReference ref = persp.getActiveFastView();
                if (ref != null) {
                    persp.setActiveFastView(null);
                }
                persp.setActiveFastView(FastViewBar.this.selectedView);
            }
        }
    };
    private Map viewOrientation = new HashMap();
    private Listener menuListener;

    public FastViewBar(WorkbenchWindow theWindow) {
        this.window = theWindow;
        this.window.addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                FastViewBar.this.update(true);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                FastViewBar.this.update(true);
            }
        });
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.side.addChangeListener(new IChangeListener(){

            public void update(boolean changed) {
                if (changed && Geometry.isHorizontal((int)FastViewBar.this.getSide()) != Geometry.isHorizontal((int)FastViewBar.this.lastSide)) {
                    FastViewBar.this.disposeChildControls();
                    FastViewBar.this.createChildControls();
                }
                FastViewBar.this.lastSide = FastViewBar.this.getSide();
            }
        });
        this.currentOrientation.addChangeListener(this.orientationChangeListener);
        this.createChildControls();
    }

    protected void createChildControls() {
        int newSide = this.getSide();
        int flags = Geometry.isHorizontal((int)newSide) ? 256 : 512;
        this.fastViewBar = new ToolBarManager(0x800000 | flags);
        this.fastViewBar.add((IContributionItem)new ShowFastViewContribution(this.window));
        this.menuListener = new Listener(){

            public void handleEvent(Event event) {
                Point loc = new Point(event.x, event.y);
                if (event.type == 35) {
                    FastViewBar.this.showFastViewBarPopup(loc);
                } else if (event.type == 3 && FastViewBar.this.getViewAt(FastViewBar.this.getToolBar().toDisplay(loc)) == null) {
                    Perspective persp = FastViewBar.this.window.getActiveWorkbenchPage().getActivePerspective();
                    persp.setActiveFastView(null, 0);
                }
            }
        };
        GridLayout controlLayout = new GridLayout();
        controlLayout.numColumns = 1;
        controlLayout.marginHeight = 0;
        controlLayout.marginWidth = 0;
        this.control.setLayout((Layout)controlLayout);
        if (newSide == 1024) {
            controlLayout.numColumns = 3;
            this.fastViewLabel = this.createFastViewSeparator(this.control);
        }
        this.fastViewBar.createControl(this.control);
        if (newSide == 1024) {
            this.fastViewLabel2 = this.createFastViewSeparator(this.control);
        }
        this.getToolBar().addListener(35, this.menuListener);
        this.getToolBar().addListener(3, this.menuListener);
        AbstractDragSource fastViewDragSource = new AbstractDragSource(){
            IViewReference oldFastView = null;

            public Object getDraggedItem(Point position) {
                IViewReference ref = FastViewBar.this.getViewAt(position);
                if (ref == null) {
                    return FastViewBar.this;
                }
                ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
                return pane;
            }

            public Rectangle getDragRectangle(Object draggedItem) {
                if (draggedItem instanceof FastViewBar) {
                    return DragUtil.getDisplayBounds((Control)FastViewBar.this.control);
                }
                ViewPane pane = (ViewPane)draggedItem;
                ToolItem item = FastViewBar.this.itemFor(pane.getViewReference());
                return Geometry.toDisplay((Control)FastViewBar.this.getToolBar(), (Rectangle)item.getBounds());
            }

            public void dragFinished(Object draggedItem, boolean success) {
                Perspective persp;
                if (this.oldFastView != null && (persp = FastViewBar.this.window.getActiveWorkbenchPage().getActivePerspective()).isFastView(this.oldFastView)) {
                    persp.setActiveFastView(this.oldFastView);
                }
                this.oldFastView = null;
            }

            public void dragStarted(Object draggedItem) {
                Perspective persp = FastViewBar.this.window.getActiveWorkbenchPage().getActivePerspective();
                this.oldFastView = persp.getActiveFastView();
                persp.setActiveFastView(null, 0);
            }
        };
        IDragOverListener fastViewDragTarget = new IDragOverListener(){

            public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
                if (draggedObject instanceof ViewPane) {
                    ViewPane pane = (ViewPane)draggedObject;
                    ToolItem targetItem = FastViewBar.this.getToolItem(position);
                    if (pane.getWorkbenchWindow() != FastViewBar.this.window) {
                        return null;
                    }
                    return new ViewDropTarget((ViewPane)draggedObject, targetItem);
                }
                return null;
            }

            class ViewDropTarget
            extends AbstractDropTarget {
                ViewPane pane;
                ToolItem position;

                public ViewDropTarget(ViewPane toDrop, ToolItem position) {
                    this.pane = toDrop;
                    this.position = position;
                }

                public void drop() {
                    IViewReference view = FastViewBar.this.getViewFor(this.position);
                    this.pane.getPage().addFastView(this.pane.getViewReference());
                    this.pane.getPage().getActivePerspective().moveFastView(this.pane.getViewReference(), view);
                    FastViewBar.this.update(true);
                }

                public Cursor getCursor() {
                    return DragCursors.getCursor(7);
                }

                public Rectangle getSnapRectangle() {
                    if (this.position == null) {
                        if (FastViewBar.this.getToolBar().getItemCount() > 0) {
                            return FastViewBar.this.getLocationOfNextIcon();
                        }
                        return DragUtil.getDisplayBounds(FastViewBar.this.getControl());
                    }
                    return Geometry.toDisplay((Control)FastViewBar.this.getToolBar(), (Rectangle)this.position.getBounds());
                }
            }
        };
        this.toolBarData = new GridData(1808);
        this.toolBarData.widthHint = 5;
        this.visible = false;
        this.getToolBar().setLayoutData((Object)this.toolBarData);
        DragUtil.addDragSource((Control)this.getToolBar(), fastViewDragSource);
        DragUtil.addDragTarget(this.getControl(), fastViewDragTarget);
        if (this.fastViewLabel != null) {
            DragUtil.addDragSource((Control)this.fastViewLabel, fastViewDragSource);
        }
        if (this.fastViewLabel2 != null) {
            DragUtil.addDragSource((Control)this.fastViewLabel2, fastViewDragSource);
        }
        this.update(true);
    }

    private Label createFastViewSeparator(Composite control2) {
        Label result = new Label(control2, 514);
        result.addListener(35, this.menuListener);
        if (this.moveCursor == null) {
            this.moveCursor = new Cursor((Device)this.control.getDisplay(), 5);
        }
        result.setCursor(this.moveCursor);
        GridData data = new GridData(1040);
        data.heightHint = 10;
        data.widthHint = 10;
        data.verticalAlignment = 2;
        data.horizontalAlignment = 2;
        result.setLayoutData((Object)data);
        return result;
    }

    private ToolBar getToolBar() {
        return this.fastViewBar.getControl();
    }

    private IViewReference getViewFor(ToolItem item) {
        if (item == null) {
            return null;
        }
        return (IViewReference)item.getData("FastView");
    }

    private IViewReference getViewAt(Point position) {
        return this.getViewFor(this.getToolItem(position));
    }

    private ToolItem getToolItem(Point position) {
        ToolBar toolbar = this.getToolBar();
        Point local = toolbar.toControl(position);
        return toolbar.getItem(local);
    }

    private Perspective getPerspective(ViewPane pane) {
        return pane.getPage().getActivePerspective();
    }

    private void showFastViewBarPopup(Point pt) {
        ToolBar toolBar = this.getToolBar();
        if (this.fastViewBarMenu == null) {
            Menu menu = new Menu((Control)toolBar);
            this.closeItem = new MenuItem(menu, 0);
            this.closeItem.setText(WorkbenchMessages.getString("WorkbenchWindow.close"));
            this.closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FastViewBar.this.selectedView != null) {
                        FastViewBar.this.window.getActiveWorkbenchPage().hideView(FastViewBar.this.selectedView);
                    }
                }
            });
            this.restoreItem = new MenuItem(menu, 0);
            this.restoreItem.setText(WorkbenchMessages.getString("WorkbenchWindow.restore"));
            this.restoreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FastViewBar.this.selectedView != null) {
                        FastViewBar.this.window.getActiveWorkbenchPage().removeFastView(FastViewBar.this.selectedView);
                    }
                }
            });
            this.orientationItem = new MenuItem(menu, 64);
            this.orientationItem.setText(WorkbenchMessages.getString("FastViewBar.view_orientation"));
            Menu orientationSwtMenu = new Menu(this.orientationItem);
            RadioMenu orientationMenu = new RadioMenu(orientationSwtMenu, this.currentOrientation);
            orientationMenu.addMenuItem(WorkbenchMessages.getString("FastViewBar.horizontal"), new Integer(256));
            orientationMenu.addMenuItem(WorkbenchMessages.getString("FastViewBar.vertical"), new Integer(512));
            this.orientationItem.setMenu(orientationSwtMenu);
            new MenuItem(menu, 2);
            this.showOn = new MenuItem(menu, 64);
            this.showOn.setText(WorkbenchMessages.getString("FastViewBar.dock_on"));
            this.sidesMenu = new Menu(this.showOn);
            this.radioButtons = new RadioMenu(this.sidesMenu, this.side);
            this.radioButtons.addMenuItem(WorkbenchMessages.getString("FastViewBar.Left"), new Integer(16384));
            this.radioButtons.addMenuItem(WorkbenchMessages.getString("FastViewBar.Right"), new Integer(131072));
            this.radioButtons.addMenuItem(WorkbenchMessages.getString("FastViewBar.Bottom"), new Integer(1024));
            this.showOn.setMenu(this.sidesMenu);
            this.fastViewBarMenu = menu;
        }
        this.selectedView = this.getViewAt(pt);
        boolean selectingView = this.selectedView != null;
        this.restoreItem.setEnabled(selectingView);
        this.closeItem.setEnabled(selectingView);
        this.orientationItem.setEnabled(selectingView);
        if (selectingView) {
            this.currentOrientation.set(this.isHorizontal(this.selectedView) ? 256 : 512, this.orientationChangeListener);
        }
        this.fastViewBarMenu.setLocation(pt.x, pt.y);
        this.fastViewBarMenu.setVisible(true);
    }

    public Control getControl() {
        return this.control;
    }

    public void dispose() {
        if (this.radioButtons != null) {
            this.radioButtons.dispose();
        }
        this.disposeChildControls();
    }

    protected void disposeChildControls() {
        this.fastViewBar.dispose();
        this.fastViewBar = null;
        if (this.fastViewLabel != null) {
            this.fastViewLabel.dispose();
            this.fastViewLabel = null;
        }
        if (this.fastViewLabel2 != null) {
            this.fastViewLabel2.dispose();
            this.fastViewLabel2 = null;
        }
        if (this.moveCursor != null) {
            this.moveCursor.dispose();
            this.moveCursor = null;
        }
        this.oldLength = 0;
    }

    public void update(boolean force) {
        boolean shouldExpand;
        this.fastViewBar.update(force);
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        boolean bl = shouldExpand = items.length > 0;
        if (shouldExpand != this.visible) {
            this.getToolBar().setVisible(true);
            this.toolBarData.widthHint = !shouldExpand ? 5 : -1;
            this.visible = shouldExpand;
        }
        if (items.length != this.oldLength) {
            this.control.getParent().layout();
            this.oldLength = items.length;
        }
        int idx = 0;
        while (idx < items.length) {
            IViewReference view = this.getViewFor(items[idx]);
            this.viewOrientation.put(view.getId(), new Integer(this.isHorizontal(view) ? 256 : 512));
            ++idx;
        }
    }

    public IViewReference getSelection() {
        return this.selection;
    }

    public void setSelection(IViewReference selected) {
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item;
            item.setSelection(this.getView(item = items[i]) == selected);
            ++i;
        }
        this.selection = selected;
    }

    private IViewReference getView(ToolItem item) {
        return (IViewReference)item.getData("FastView");
    }

    private int getIndex(IViewReference toFind) {
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("FastView") == toFind) {
                return i;
            }
            ++i;
        }
        return items.length;
    }

    private ToolItem getItem(int idx) {
        ToolItem[] items = this.fastViewBar.getControl().getItems();
        if (idx >= items.length) {
            return null;
        }
        return items[idx];
    }

    private ToolItem itemFor(IViewReference toFind) {
        return this.getItem(this.getIndex(toFind));
    }

    public int getValidSides() {
        return 148480;
    }

    public void dock(int side) {
        this.side.set(side);
    }

    public int getSide() {
        return this.side.get();
    }

    public void addDockingListener(IChangeListener listener) {
        this.side.addChangeListener(listener);
    }

    private boolean isHorizontal(IViewReference ref) {
        boolean horizontalBar;
        Integer orientation = (Integer)this.viewOrientation.get(ref.getId());
        boolean horizontal = horizontalBar = Geometry.isHorizontal((int)this.getSide());
        if (orientation != null) {
            horizontal = orientation == 256;
        } else {
            ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
            if (pane != null && pane.getControl() != null) {
                Rectangle bounds = pane.getBounds();
                if (bounds.width != bounds.height) {
                    horizontal = bounds.width > bounds.height;
                }
            }
        }
        return horizontal;
    }

    public int getViewSide(IViewReference ref) {
        boolean horizontal = this.isHorizontal(ref);
        if (horizontal) {
            return this.getSide() == 1024 ? 1024 : 128;
        }
        return this.getSide() == 131072 ? 131072 : 16384;
    }

    public void saveState(IMemento memento) {
        memento.putInteger("fastViewLocation", this.getSide());
        Iterator iter = this.viewOrientation.keySet().iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            IMemento orientation = memento.createChild("orientation");
            orientation.putString("view", next);
            orientation.putInteger("position", (Integer)this.viewOrientation.get(next));
        }
    }

    public Rectangle getLocationOfNextIcon() {
        ToolBar control = this.getToolBar();
        Rectangle result = control.getBounds();
        Point size = control.computeSize(-1, -1, false);
        result.height = size.y;
        result.width = size.x;
        boolean horizontal = Geometry.isHorizontal((int)this.getSide());
        int hoverSide = horizontal ? 131072 : 1024;
        result = Geometry.getExtrudedEdge((Rectangle)result, (int)(-Geometry.getDimension((Rectangle)result, (!horizontal ? 1 : 0) != 0)), (int)hoverSide);
        return Geometry.toDisplay((Control)control.getParent(), (Rectangle)result);
    }

    public void restoreState(IMemento memento) {
        Integer bigInt = memento.getInteger("fastViewLocation");
        if (bigInt != null) {
            this.dock(bigInt);
        }
        IMemento[] orientations = memento.getChildren("orientation");
        int i = 0;
        while (i < orientations.length) {
            IMemento next = orientations[i];
            this.viewOrientation.put(next.getString("view"), next.getInteger("position"));
            ++i;
        }
    }
}

