/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.progress.UIJob;

public class RectangleAnimation
extends Job {
    private Rectangle start;
    private int elapsed;
    private int duration;
    private long startTime = 0L;
    private Rectangle end;
    private Rectangle last;
    private boolean done = false;
    private Canvas canvas;
    private UIJob paintJob = new UIJob(WorkbenchMessages.getString("RectangleAnimation.Animating_Rectangle")){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (RectangleAnimation.this.canvas == null || RectangleAnimation.this.canvas.isDisposed()) {
                RectangleAnimation.this.done = true;
                return Status.OK_STATUS;
            }
            RectangleAnimation.this.canvas.redraw();
            return Status.OK_STATUS;
        }
    };

    private static Rectangle interpolate(Rectangle start, Rectangle end, double amount) {
        double initialWeight = 1.0 - amount;
        Rectangle result = new Rectangle((int)((double)start.x * initialWeight + (double)end.x * amount), (int)((double)start.y * initialWeight + (double)end.y * amount), (int)((double)start.width * initialWeight + (double)end.width * amount), (int)((double)start.height * initialWeight + (double)end.height * amount));
        return result;
    }

    private void draw(GC gc) {
        if (this.startTime == 0L) {
            return;
        }
        if (this.canvas == null || this.canvas.isDisposed()) {
            this.done = true;
            return;
        }
        long currentTime = System.currentTimeMillis();
        double amount = (double)(currentTime - this.startTime) / (double)this.duration;
        if (amount > 1.0) {
            amount = 1.0;
            this.done = true;
        }
        Rectangle toPaint = RectangleAnimation.interpolate(this.start, this.end, amount);
        gc.setLineWidth(2);
        Color color = this.canvas.getDisplay().getSystemColor(1);
        gc.setForeground(color);
        gc.setXORMode(true);
        if (this.last != null) {
            if (this.last.equals((Object)toPaint)) {
                return;
            }
            gc.drawRectangle(Geometry.toControl((Control)this.canvas, (Rectangle)this.last));
        }
        gc.drawRectangle(Geometry.toControl((Control)this.canvas, (Rectangle)toPaint));
        this.last = toPaint;
    }

    public RectangleAnimation(Composite whereToDraw, Rectangle start, Rectangle end, int duration) {
        super(WorkbenchMessages.getString("RectangleAnimation.Animating_Rectangle"));
        this.duration = duration;
        this.start = start;
        this.end = end;
        this.canvas = new Canvas(whereToDraw, 262144);
        this.setSystem(true);
        this.canvas.setBounds(whereToDraw.getClientArea());
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                RectangleAnimation.this.draw(event.gc);
            }
        });
        this.canvas.moveAbove(null);
        this.paintJob.setPriority(10);
        this.paintJob.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.startTime = System.currentTimeMillis();
        while (!this.done) {
            this.paintJob.schedule();
            try {
                this.paintJob.join();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!this.canvas.isDisposed()) {
            this.canvas.getDisplay().syncExec(new Runnable(){

                public void run() {
                    RectangleAnimation.this.canvas.dispose();
                }
            });
        }
        return Status.OK_STATUS;
    }
}

